/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.axis;

import java.io.File;
import java.util.Vector;
import org.apache.velocity.VelocityContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ws.JaxRpcPortComponentDesc;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.generators.wsgen.ddmodifier.WebServicesDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsEndpointDDModifier;
import org.ow2.jonas.generators.wsgen.generator.WsEndpointGenerator;
import org.ow2.jonas.generators.wsgen.generator.axis.JVelocity;
import org.ow2.jonas.generators.wsgen.generator.axis.VContextFactory;
import org.ow2.jonas.lib.util.Log;

public class AxisWsEndpointGenerator
extends WsEndpointGenerator {
    private static JVelocity jvelocity = null;
    private static Logger logger = Log.getLogger("org.ow2.jonas.generators.wsgen");
    private static final String AXIS_SERVLET_CLASS = "org.ow2.jonas.ws.axis.JAxisServlet";
    private static final String SERVER_CONFIG = "axis.serverConfigFile";
    private static final String WSDD_SUFFIX = ".wsdd";
    private static final String WSDD_PREFIX = "deploy-server-";
    private static int count = 0;
    private File generatedServerConfig;

    public AxisWsEndpointGenerator(Config config, ServiceDesc serviceDesc, WsEndpointDDModifier ddm, WebServicesDDModifier wsddm, Archive arch) throws GenBaseException, WsGenException {
        super(config, serviceDesc, ddm, wsddm, arch);
        if (jvelocity == null) {
            String packageName = this.getClass().getPackage().getName();
            packageName = packageName.replace('.', '/');
            jvelocity = new JVelocity(packageName + "/deploy_endpoint.vm");
        }
    }

    public void generate() throws WsGenException {
        String sName = this.getService().getName();
        VelocityContext vc = VContextFactory.getContext(this.getService());
        String filename = WSDD_PREFIX + count++ + WSDD_SUFFIX;
        this.generatedServerConfig = new File(this.getSources(), filename);
        jvelocity.generate(this.generatedServerConfig, vc);
        for (Object obj : this.getService().getPortComponents()) {
            if (!(obj instanceof JaxRpcPortComponentDesc)) continue;
            JaxRpcPortComponentDesc jax = (JaxRpcPortComponentDesc)obj;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Removing servlet '" + jax.getSibLink() + "'"));
            }
            this.getModifier().removeServletMapping(jax.getSibLink());
            this.getModifier().removeServlet(jax.getSibLink());
            this.getWsModifier().changeServletLink(sName, jax.getSibLink(), sName);
        }
        this.getModifier().addServlet(sName, AXIS_SERVLET_CLASS);
        this.getModifier().addServletParam(sName, SERVER_CONFIG, filename);
        boolean requireDefaultMapping = false;
        Vector<String> usedServletMappings = new Vector<String>();
        for (PortComponentDesc pcd : this.getService().getPortComponents()) {
            String mapping = pcd.getMapping();
            if (mapping != null) {
                if (usedServletMappings.contains(mapping)) continue;
                usedServletMappings.add(mapping);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Adding servlet-mapping for '" + sName + "' -> '" + mapping + "'"));
                }
                this.getModifier().addServletMapping(sName, mapping);
                continue;
            }
            requireDefaultMapping = true;
        }
        if (requireDefaultMapping) {
            String defaultEndpointURI = this.getService().getEndpointURI();
            if (defaultEndpointURI == null) {
                this.getModifier().addServletMapping(sName, "/" + sName + "/*");
            } else {
                this.getModifier().addServletMapping(sName, defaultEndpointURI);
            }
        }
    }

    public void addFiles(Archive archive) throws WsGenException {
        if (!(archive instanceof WebApp)) {
            String err = AxisWsEndpointGenerator.getI18n().getMessage("AxisWsEndpointGenerator.addFiles.illegal", archive.getRootFile());
            throw new IllegalArgumentException(err);
        }
        WebApp web = (WebApp)archive;
        web.addFileIn("WEB-INF/", this.generatedServerConfig);
    }
}

