/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.bootstrap;

import java.io.File;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.JURLs;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.loader.OSGiClassLoader;

public final class LoaderManager {
    private static LoaderManager instance = null;
    private JClassLoader externalClassLoader = null;
    private String jonasRoot = JProp.getJonasRoot();
    private String jonasBase = JProp.getJonasBase();
    private File jonasRootLib = new File(this.jonasRoot, "lib");
    private File jonasRootLibExt = new File(this.jonasRootLib, "ext");
    private static final String LIB = "lib";
    private static final String EXTERNAL_FOLDER = "ext";
    private static final String LIB_EXTERNAL = "lib" + File.separator + "ext";
    private static final String TLD_FOLDER = "internal-ee-tld";

    private LoaderManager() {
    }

    public static LoaderManager getInstance() {
        if (instance == null) {
            instance = new LoaderManager();
        }
        return instance;
    }

    public JClassLoader getExternalLoader() throws Exception {
        if (this.externalClassLoader == null) {
            this.externalClassLoader = this.createExternalClassLoader();
        }
        return this.externalClassLoader;
    }

    private JClassLoader createExternalClassLoader() throws Exception {
        File jonasBaseLibExt;
        JURLs jurls = new JURLs();
        jurls.add(new File(this.jonasRootLib, TLD_FOLDER), "javaee-tld.jar");
        jurls.add(this.jonasRootLibExt, ".jar");
        if (!this.jonasRoot.toLowerCase().equals(this.jonasBase.toLowerCase()) && (jonasBaseLibExt = new File(this.jonasBase, LIB_EXTERNAL)).exists()) {
            jurls.add(jonasBaseLibExt, ".jar");
        }
        return new JClassLoader("External", jurls.toURLs(), new OSGiClassLoader());
    }
}

