/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans.log;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.lib.jmbeans.log.LogBufferMBean;
import org.ow2.jonas.lib.jmbeans.log.LogNotificationListener;
import org.ow2.jonas.lib.jmbeans.log.LogRecordComparator;
import org.ow2.jonas.lib.jmbeans.log.RecordFeeder;
import org.ow2.jonas.lib.util.JonasObjectName;

public class LogBuffer
implements LogBufferMBean,
MBeanRegistration {
    private int level = 2;
    private long recordGauge = 0L;
    private long recordCount = 0L;
    private long infoCount = 0L;
    private long warningCount = 0L;
    private long severeCount = 0L;
    private long otherCount = 0L;
    private ArrayList recent = new ArrayList();
    private long oldestDate = 0L;
    private long latestDate = 0L;
    private Object recentLock = new Object();
    private MBeanServer mbeanServer = null;
    private ObjectName logManagementOn = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss-SSS");
    private LogNotificationListener listener = null;
    private String name = "log";
    private String domain = null;
    private LinkedList queue = new LinkedList();
    private int capacity = 100000;
    private int estimLogRecordSize = 1000;
    private TreeSet recordSet = new TreeSet(new LogRecordComparator());
    private Thread feederThread = null;
    private int recentCapacity = 10;

    public LogBuffer(String name) {
        this.name = name;
    }

    public StringBuffer fetchRecords() {
        TreeSet newset = this.fetchRecordsSet();
        int estimSz = newset.size() * this.estimLogRecordSize;
        StringBuffer buf = new StringBuffer(estimSz);
        Iterator it = newset.iterator();
        while (it.hasNext()) {
            this.appendRecord((LogRecord)it.next(), buf);
        }
        newset.clear();
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet fetchRecordsSet() {
        TreeSet myset = null;
        TreeSet treeSet = this.recordSet;
        synchronized (treeSet) {
            myset = (TreeSet)this.recordSet.clone();
        }
        return myset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet fetchRecordsSet(Long from, Long to) {
        TreeSet myset = null;
        LogRecord recfrom = new LogRecord(Level.ALL, "from");
        recfrom.setMillis(from);
        recfrom.setSequenceNumber(0L);
        LogRecord recto = new LogRecord(Level.ALL, "to");
        recto.setMillis(to);
        recto.setSequenceNumber(Long.MAX_VALUE);
        SortedSet<LogRecord> sset = null;
        TreeSet treeSet = this.recordSet;
        synchronized (treeSet) {
            sset = from == 0L ? this.recordSet.headSet(recto) : (to == 0L ? this.recordSet.tailSet(recfrom) : this.recordSet.subSet(recfrom, recto));
            myset = (TreeSet)((TreeSet)sset).clone();
        }
        return myset;
    }

    public StringBuffer fetchRecords(Long from, Long to) {
        long tto;
        StringBuffer buf = null;
        long tfrom = from == null ? 0L : from;
        long l = tto = to == null ? 0L : to;
        if (tfrom > tto) {
            return null;
        }
        if (tfrom == 0L && tto == 0L) {
            buf = this.fetchRecords();
        } else {
            TreeSet newset = this.fetchRecordsSet(from, to);
            int estimSz = newset.size() * this.estimLogRecordSize;
            buf = new StringBuffer(estimSz);
            Iterator it = newset.iterator();
            while (it.hasNext()) {
                this.appendRecord((LogRecord)it.next(), buf);
            }
            newset.clear();
        }
        return buf;
    }

    public StringBuffer fetchRecords(Long from, Long to, int level) {
        StringBuffer buf = null;
        long tfrom = from == null ? 0L : from;
        long tto = to == null ? 0L : to;
        TreeSet newset = null;
        if (tfrom > tto) {
            return null;
        }
        newset = tfrom == 0L && tto == 0L ? this.fetchRecordsSet() : this.fetchRecordsSet(from, to);
        TreeSet<LogRecord> newsetWithLevels = new TreeSet<LogRecord>();
        for (LogRecord rec : newset) {
            if (rec.getLevel().intValue() <= level) continue;
            newsetWithLevels.add(rec);
        }
        newset.clear();
        int estimSz = newsetWithLevels.size() * this.estimLogRecordSize;
        buf = new StringBuffer(estimSz);
        Iterator it = newsetWithLevels.iterator();
        while (it.hasNext()) {
            this.appendRecord((LogRecord)it.next(), buf);
        }
        newsetWithLevels.clear();
        return buf;
    }

    private void appendRecord(LogRecord record, StringBuffer buf) {
        buf.append(record.getLevel().getName());
        buf.append("; ");
        buf.append(this.dateFormat.format(new Date(record.getMillis())));
        buf.append("; ");
        buf.append(record.getMessage());
        buf.append("\n");
        Throwable th = record.getThrown();
        if (th != null) {
            this.appendThrowable(th, buf);
        }
    }

    private void appendThrowable(Throwable th, StringBuffer buf) {
        buf.append(th.getClass());
        buf.append(": ");
        buf.append(th.getMessage());
        StackTraceElement[] stack = th.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            buf.append("\n\t");
            buf.append(stack[i].toString());
        }
        buf.append("\n");
        th = th.getCause();
        if (th != null) {
            buf.append("Caused by:\n");
            this.appendThrowable(th, buf);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getInfoCount() {
        return this.infoCount;
    }

    protected void incInfoCount() {
        ++this.infoCount;
    }

    public int getLevel() {
        return this.level;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    protected void incRecordCount() {
        ++this.recordCount;
    }

    public long getSevereCount() {
        return this.severeCount;
    }

    protected void incSevereCount() {
        ++this.severeCount;
    }

    public long getWarningCount() {
        return this.warningCount;
    }

    protected void incWarningCount() {
        ++this.warningCount;
    }

    public long getOtherCount() {
        return this.otherCount;
    }

    protected void incOtherCount() {
        ++this.otherCount;
    }

    public long getLatestDate() {
        return this.latestDate;
    }

    public void setCapacity(int records) {
        this.capacity = records;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRecent() {
        LogRecord[] lra;
        Object object = this.recentLock;
        synchronized (object) {
            lra = new LogRecord[this.recent.size()];
            lra = this.recent.toArray(lra);
        }
        int estimSz = this.recentCapacity * this.estimLogRecordSize;
        StringBuffer buf = new StringBuffer(estimSz);
        for (int i = 0; i < lra.length; ++i) {
            this.appendRecord(lra[i], buf);
        }
        return buf.toString();
    }

    private void locateLogSource() {
        if (this.logManagementOn == null) {
            ObjectName on = null;
            on = this.domain != null ? JonasObjectName.logService(this.domain) : JonasObjectName.logService();
            Set<ObjectName> son = this.mbeanServer.queryNames(on, null);
            if (!son.isEmpty()) {
                this.logManagementOn = son.iterator().next();
            }
        }
    }

    private String getDomain() {
        return this.domain;
    }

    public void postRegister(Boolean arg0) {
        if (!arg0.booleanValue()) {
            return;
        }
        this.listener = new LogNotificationListener(this);
        try {
            this.mbeanServer.addNotificationListener(this.logManagementOn, this.listener, null, null);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        RecordFeeder feeder = new RecordFeeder(this.queue, this.recordSet);
        feeder.setMaxRecords(this.capacity);
        this.feederThread = new Thread((Runnable)feeder, "LogRecorder");
        this.feederThread.setDaemon(true);
        this.feederThread.start();
    }

    public ObjectName preRegister(MBeanServer mbs, ObjectName on) throws MalformedObjectNameException {
        this.mbeanServer = mbs;
        if (on != null) {
            this.domain = on.getDomain();
        }
        this.locateLogSource();
        if (on == null) {
            on = ObjectName.getInstance(this.getDomain() + ":type=LogBuffer,name=" + this.name);
        }
        return on;
    }

    public void preDeregister() throws Exception {
        this.mbeanServer.removeNotificationListener(this.logManagementOn, this.listener);
        this.feederThread.interrupt();
        this.feederThread = null;
    }

    public void postDeregister() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToRecentLog(LogRecord record) {
        Object object = this.recentLock;
        synchronized (object) {
            if (this.recent.size() == this.recentCapacity) {
                this.recent.remove(0);
            }
            this.recent.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToLogRecordsQueue(LogRecord record) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(record);
        }
    }

    public int getRecentCapacity() {
        return this.recentCapacity;
    }

    public void setRecentCapacity(int recentCapacity) {
        this.recentCapacity = recentCapacity;
    }

    protected void setLatestDate(long latestDate) {
        this.latestDate = latestDate;
    }

    public long getOldestDate() {
        return this.oldestDate;
    }

    public void setOldestDate(long oldestDate) {
        this.oldestDate = oldestDate;
    }
}

