/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans.monitoring;

import org.ow2.jonas.lib.timer.TimerEvent;
import org.ow2.jonas.lib.timer.TimerEventListener;
import org.ow2.jonas.lib.timer.TimerManager;

public class MemoryMonitoring
implements TimerEventListener {
    private int sizeTableMeasures = 120;
    private int range = 10;
    private Long[] tableMeasures;
    private long maxtotalmemory;
    private TimerEvent mytimer = null;
    private TimerManager timerManager = null;
    private boolean activated = false;

    public Long[] getTableMeasures() {
        return this.tableMeasures;
    }

    public boolean getActivated() {
        return this.activated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivated(boolean pActivated) {
        if (pActivated) {
            if (!this.activated) {
                MemoryMonitoring memoryMonitoring = this;
                synchronized (memoryMonitoring) {
                    this.activated = true;
                    this.initTable();
                }
                long timeout = this.range * 1000;
                this.mytimer = this.timerManager.addTimerMs(this, timeout, new Integer(1), true);
            }
        } else if (this.activated) {
            MemoryMonitoring memoryMonitoring = this;
            synchronized (memoryMonitoring) {
                this.activated = false;
                this.initTable();
                this.mytimer.stop();
                this.mytimer.unset();
            }
        }
    }

    public int getRange() {
        return this.range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(int range) {
        if (this.range != range) {
            MemoryMonitoring memoryMonitoring = this;
            synchronized (memoryMonitoring) {
                if (range < 10) {
                    throw new IllegalArgumentException("range could not be < 10");
                }
                this.range = range;
                this.initTable();
                this.mytimer.change(this.range * 1000, new Integer(1));
            }
        }
    }

    public int getSizeTableMeasures() {
        return this.sizeTableMeasures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeTableMeasures(int sizeMeasuresTable) {
        if (sizeMeasuresTable != this.sizeTableMeasures) {
            MemoryMonitoring memoryMonitoring = this;
            synchronized (memoryMonitoring) {
                if (sizeMeasuresTable <= 1) {
                    throw new IllegalArgumentException("number of measures could not be <= 1");
                }
                this.sizeTableMeasures = sizeMeasuresTable;
                this.initTable();
            }
        }
    }

    public void timeoutExpired(Object arg) {
        int argvalue = (Integer)arg;
        switch (argvalue) {
            case 1: {
                long uvalue = this.usedMemory();
                long tmvalue = this.totalMemory();
                if (tmvalue > this.maxtotalmemory) {
                    this.maxtotalmemory = tmvalue;
                }
                for (int i = 0; i < this.tableMeasures.length; ++i) {
                    this.tableMeasures[i] = i != this.tableMeasures.length - 1 ? this.tableMeasures[i + 1] : new Long(uvalue);
                }
                break;
            }
        }
    }

    private void initTable() {
        this.tableMeasures = new Long[this.sizeTableMeasures];
        this.maxtotalmemory = this.totalMemory();
        for (int i = 0; i < this.tableMeasures.length; ++i) {
            this.tableMeasures[i] = new Long(0L);
        }
        this.tableMeasures[this.tableMeasures.length - 1] = new Long(this.usedMemory());
    }

    public long usedMemory() {
        long result = -1L;
        while (result < 0L) {
            result = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        }
        return result / 1000L;
    }

    public long totalMemory() {
        return Runtime.getRuntime().totalMemory() / 1000L;
    }

    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    public void setTimerManager(TimerManager timerManager) {
        this.timerManager = timerManager;
    }
}

