/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.clusterdaemon;

import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.base.ManagementException;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.extensions.clusterdaemon.api.IClusterdaemon;

public class ClusterdaemonManagement
extends BaseManagement
implements IClusterdaemon {
    private static final String state = "State";
    private static final String controlledServersNames = "ControlledServersNames";
    private static final String runningState = "RUNNING";

    private ObjectName getClusterdaemonOn(String clusterdaemonName) {
        String domain = this.getDomainName();
        ObjectName clusterdaemonOn = null;
        try {
            clusterdaemonOn = JonasObjectName.clusterDaemonProxy(domain, clusterdaemonName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return clusterdaemonOn;
    }

    public String getClusterdaemonState(String clusterdaemonName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        String clusterdaemonState = null;
        try {
            clusterdaemonState = (String)JonasManagementRepr.getAttribute(clusterdaemonOn, state, this.getServerName());
        }
        catch (ManagementException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get state for cluster daemon " + clusterdaemonName + " :" + e));
        }
        return clusterdaemonState;
    }

    public boolean isRunning(String clusterdaemonName) {
        boolean result = false;
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        try {
            String clusterdaemonState = (String)JonasManagementRepr.getAttribute(clusterdaemonOn, state, this.getServerName());
            if (runningState.equals(clusterdaemonState)) {
                result = true;
            }
        }
        catch (ManagementException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get state for cluster daemon " + clusterdaemonName + " :" + e));
        }
        return result;
    }

    public String[] getControlledServersNames(String clusterdaemonName) {
        ObjectName clusterdaemonOn = this.getClusterdaemonOn(clusterdaemonName);
        ArrayList servers = new ArrayList();
        try {
            servers = (ArrayList)JonasManagementRepr.getAttribute(clusterdaemonOn, controlledServersNames, this.getServerName());
            if (servers == null) {
                return new String[0];
            }
        }
        catch (ManagementException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get controlled server names for cluster daemon " + clusterdaemonName + " :" + e));
            return null;
        }
        String[] controlledServers = new String[servers.size()];
        for (int i = 0; i < servers.size(); ++i) {
            controlledServers[i] = (String)servers.get(i);
        }
        return controlledServers;
    }
}

