/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal.factory;

import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.PropDump;
import org.ow2.jonas.mail.MailService;
import org.ow2.jonas.mail.factory.JavaMail;

public abstract class AbstractJavaMail
implements JavaMail {
    private static Logger logger = null;
    private String factoryName = null;
    private String name = null;
    private MailService mailService = null;
    private Properties mailSessionProperties = null;
    private Properties authenticationProperties = null;
    private static final String PROPERTY_AUTHENTICATION_USERNAME = "mail.authentication.username";
    private static final String PROPERTY_AUTHENTICATION_PASSWORD = "mail.authentication.password";

    public AbstractJavaMail(String factoryName, String name, Properties mailProperties, MailService mailService) {
        if (logger == null) {
            logger = Log.getLogger("org.ow2.jonas.mail");
        }
        this.factoryName = factoryName;
        this.name = name;
        this.mailService = mailService;
        this.mailSessionProperties = (Properties)mailProperties.clone();
        this.mailSessionProperties.remove("mail.factory.name");
        this.mailSessionProperties.remove("mail.factory.type");
        this.authenticationProperties = new Properties();
        String propValue = null;
        propValue = (String)this.mailSessionProperties.remove(PROPERTY_AUTHENTICATION_USERNAME);
        if (propValue != null) {
            this.authenticationProperties.setProperty(PROPERTY_AUTHENTICATION_USERNAME, propValue);
        }
        if ((propValue = (String)this.mailSessionProperties.remove(PROPERTY_AUTHENTICATION_PASSWORD)) != null) {
            this.authenticationProperties.setProperty(PROPERTY_AUTHENTICATION_PASSWORD, propValue);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = new String(name);
        try {
            this.mailService.renameJavaMailFactory(oldName, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public Properties getSessionProperties() {
        return this.mailSessionProperties;
    }

    public void setSessionProperties(Properties props) {
        this.mailSessionProperties = props;
        try {
            this.mailService.recreateJavaMailFactory(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            PropDump.print("These are the udated session properties", this.mailSessionProperties, logger, BasicLevel.DEBUG);
        }
    }

    public Properties getAuthenticationProperties() {
        return this.authenticationProperties;
    }

    public void setAuthenticationProperties(Properties props) {
        this.authenticationProperties = props;
        try {
            this.mailService.recreateJavaMailFactory(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            PropDump.print("These are the udated auth properties", this.authenticationProperties, logger, BasicLevel.DEBUG);
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger logger) {
        AbstractJavaMail.logger = logger;
    }

    public Properties getMailSessionProperties() {
        return this.mailSessionProperties;
    }

    public void setMailSessionProperties(Properties mailSessionProperties) {
        this.mailSessionProperties = mailSessionProperties;
    }

    public MailService getMailService() {
        return this.mailService;
    }
}

