/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.jonas.lib.security.auth.JSigned;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;

public class ClientLoginModule
implements LoginModule {
    private Subject subject = null;
    private Map options = null;
    private String principalName = null;
    private ArrayList principalRoles = null;
    private boolean globalContext = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.options = options;
        this.principalRoles = new ArrayList();
    }

    public boolean login() throws LoginException {
        String useGlobalCtx = (String)this.options.get("globalCtx");
        if (useGlobalCtx != null && Boolean.valueOf(useGlobalCtx).booleanValue()) {
            this.globalContext = true;
        }
        return true;
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals(Principal.class);
        for (Principal principal : principals) {
            if (principal instanceof Group) continue;
            this.principalName = principal.getName();
        }
        if (this.principalName == null) {
            throw new LoginException("There was no previous login module. This login module can only be used in addition to another module which perform the authentication.");
        }
        principals = this.subject.getPrincipals(Group.class);
        Iterator<Principal> iterator = principals.iterator();
        JSigned jSigned = null;
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (group instanceof JSigned) {
                jSigned = (JSigned)group;
                continue;
            }
            Enumeration e = group.members();
            while (e.hasMoreElements()) {
                Principal p = (Principal)e.nextElement();
                this.principalRoles.add(p.getName());
            }
        }
        SecurityContext ctx = new SecurityContext(this.principalName, this.principalRoles);
        if (jSigned != null) {
            ctx.setSignature(jSigned.getSignature());
        }
        SecurityCurrent current = SecurityCurrent.getCurrent();
        if (this.globalContext) {
            current.setGlobalSecurityContext(ctx);
        } else {
            current.setSecurityContext(ctx);
        }
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        SecurityContext ctx = new SecurityContext();
        SecurityCurrent current = SecurityCurrent.getCurrent();
        current.setSecurityContext(ctx);
        return true;
    }
}

