/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.internal;

import java.security.Policy;
import javax.security.jacc.PolicyConfigurationFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.security.jacc.JPolicy;
import org.ow2.jonas.lib.util.Log;

public class PolicyProvider {
    private static Logger logger = null;

    private PolicyProvider() {
    }

    public static void init() throws SecurityException {
        String jaccFactoryProvider;
        if (logger == null) {
            logger = Log.getLogger("org.ow2.jonas.security");
        }
        String javaPolicy = System.getProperty("javax.security.jacc.policy.provider");
        LoaderManager lm = LoaderManager.getInstance();
        JClassLoader externalLoader = null;
        try {
            externalLoader = lm.getExternalLoader();
        }
        catch (Exception e) {
            throw new SecurityException("cannot get  Commonsloader: " + e);
        }
        if (javaPolicy != null) {
            try {
                Policy policy = (Policy)externalLoader.loadClass(javaPolicy).newInstance();
                Policy.setPolicy(policy);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SecurityException(cnfe.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new SecurityException(iae.getMessage());
            }
            catch (InstantiationException ie) {
                throw new SecurityException(ie.getMessage());
            }
            catch (ClassCastException cce) {
                throw new SecurityException(cce.getMessage());
            }
            catch (Exception e) {
                throw new SecurityException("cannot load security policy: " + e);
            }
            logger.log(BasicLevel.INFO, (Object)("Using policy provider '" + javaPolicy + "'"));
        }
        if ((jaccFactoryProvider = System.getProperty("javax.security.jacc.PolicyConfigurationFactory.provider")) == null) {
            logger.log(BasicLevel.INFO, (Object)"Using JOnAS PolicyConfigurationFactory provider and JOnAS Policy provider");
            System.setProperty("javax.security.jacc.PolicyConfigurationFactory.provider", "org.ow2.jonas.lib.security.jacc.PolicyConfigurationFactoryWrapper");
            Policy.setPolicy(JPolicy.getInstance());
        } else {
            logger.log(BasicLevel.INFO, (Object)("Using factory '" + jaccFactoryProvider + "' as PolicyConfigurationFactory provider"));
        }
        IExecution<Void> exec = new IExecution<Void>(){

            @Override
            public Void execute() throws Exception {
                PolicyConfigurationFactory.getPolicyConfigurationFactory();
                return null;
            }
        };
        ExecutionResult<Void> result = RunnableHelper.execute(externalLoader, exec);
        if (result.hasException()) {
            Exception e = result.getException();
            throw new SecurityException("Error when trying to get the PolicyConfigurationFactory object : '" + e.getMessage() + "'.", e);
        }
    }
}

