/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.services.bootstrap;

import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationPlugin;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASConfiguration
implements ConfigurationManager,
ConfigurationPlugin {
    private ConfigurationAdmin configurationAdmin = null;
    private static final String JONAS_SERVICE = "jonas.service";
    private BundleContext bc = null;
    private List<String> mandatoryServices = null;
    private Log logger = LogFactory.getLog(JOnASConfiguration.class);
    private JProp serverProperties = null;
    private long lastModified;

    public JOnASConfiguration(BundleContext bc) {
        this.bc = bc;
        this.mandatoryServices = new ArrayList<String>();
        this.mandatoryServices.add("registry");
        this.mandatoryServices.add("jmx");
    }

    public void configure() throws Exception {
        this.deleteServiceConfigurations();
        this.manageServiceConfigurations(this.mandatoryServices, false);
        ServiceReference sr = this.bc.getServiceReference(ServerProperties.class.getName());
        if (sr == null) {
            this.bc.registerService(ServerProperties.class.getName(), (Object)this.getServerProperties(), null);
        }
    }

    @Override
    public void haltServer() throws Exception {
        this.bc.getBundle(0L).stop();
    }

    @Override
    public synchronized void updateServiceConfiguration(String service) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        services.add(service);
        this.manageServiceConfigurations(services, false);
    }

    @Override
    public synchronized void deleteServiceConfiguration(String service) throws Exception {
        ArrayList<String> services = new ArrayList<String>();
        services.add(service);
        this.manageServiceConfigurations(services, true);
    }

    @Override
    public boolean matchService(String service) {
        String serviceClass = "jonas.service." + service + ".class";
        String factoryPID = this.getServerProperties().getValue(serviceClass);
        return factoryPID != null;
    }

    private void manageServiceConfigurations(List<String> services, boolean delete) throws Exception {
        for (String service : this.removeDuplicateServices(services)) {
            Dictionary<String, String> newProperties = null;
            if (!delete) {
                newProperties = this.getServiceProperties(service);
            }
            Configuration configuration = this.getConfiguration(service);
            if (!delete && configuration == null) {
                configuration = this.configurationAdmin.createFactoryConfiguration(this.getFactoryPID(service), null);
                configuration.update(newProperties);
                continue;
            }
            if (configuration == null) continue;
            configuration = this.configurationAdmin.getConfiguration(configuration.getPid(), null);
            if (delete) {
                configuration.delete();
                continue;
            }
            Dictionary storedProperties = configuration.getProperties();
            if (!this.isConfigurationModified(storedProperties, newProperties)) continue;
            configuration.update(newProperties);
        }
    }

    @Override
    public List<String> getMandatoryServices() {
        return this.mandatoryServices;
    }

    @Override
    public List<String> getAllServices() {
        List<String> allServices = this.getOptionalServices();
        for (int i = 0; i < this.mandatoryServices.size(); ++i) {
            allServices.add(i, this.mandatoryServices.get(i));
        }
        return allServices;
    }

    @Override
    public List<String> getOptionalServices() {
        String[] declaredServices = this.getServerProperties().getValueAsArray("jonas.services");
        ArrayList<String> optionalServices = new ArrayList<String>();
        for (String declaredService : declaredServices) {
            if (this.mandatoryServices.contains(declaredService)) continue;
            optionalServices.add(declaredService);
        }
        return optionalServices;
    }

    @Override
    public Dictionary<String, String> getServiceProperties(String service) {
        JProp serverProperties = this.getServerProperties();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(JONAS_SERVICE, service);
        for (Object key : serverProperties.getConfigFileEnv().keySet()) {
            String servicePrefix;
            String name = (String)key;
            if (!name.startsWith(servicePrefix = "jonas.service." + service + ".")) continue;
            String value = serverProperties.getValue(name);
            name = name.substring(servicePrefix.length());
            ((Dictionary)props).put(name, value);
        }
        return props;
    }

    private Configuration getConfiguration(String service) throws Exception {
        Configuration[] storedConfigurations = this.configurationAdmin.listConfigurations("(service.factoryPid=" + this.getFactoryPID(service) + ")");
        if (storedConfigurations != null && storedConfigurations.length == 1) {
            return storedConfigurations[0];
        }
        return null;
    }

    private String getFactoryPID(String service) {
        String serviceClass = "jonas.service." + service + ".class";
        return this.getServerProperties().getValue(serviceClass);
    }

    public void modifyConfiguration(ServiceReference serviceReference, Dictionary storedProperties) {
        try {
            Dictionary<String, String> newProperties;
            String serviceName = (String)storedProperties.get(JONAS_SERVICE);
            if (serviceName != null && this.isConfigurationModified(storedProperties, newProperties = this.getServiceProperties(serviceName))) {
                Enumeration<String> enProps = newProperties.keys();
                while (enProps.hasMoreElements()) {
                    String key = enProps.nextElement();
                    storedProperties.put(key, newProperties.get(key));
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e, new Object[0]);
        }
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    private boolean isConfigurationModified(Dictionary<String, String> storedProperties, Dictionary<String, String> newProperties) {
        storedProperties.remove("service.pid");
        storedProperties.remove("service.factoryPid");
        storedProperties.remove("service.bundleLocation");
        if (storedProperties.size() != newProperties.size()) {
            return true;
        }
        Enumeration<String> enProps = storedProperties.keys();
        while (enProps.hasMoreElements()) {
            String key = enProps.nextElement();
            if (newProperties.get(key) == null) {
                return true;
            }
            if (storedProperties.get(key).equals(newProperties.get(key))) continue;
            return true;
        }
        return false;
    }

    private void deleteServiceConfigurations() throws Exception {
        Configuration[] storedConfigurations = this.configurationAdmin.listConfigurations(null);
        if (storedConfigurations != null) {
            for (Configuration configuration : storedConfigurations) {
                String serviceName = (String)configuration.getProperties().get(JONAS_SERVICE);
                if (serviceName == null) continue;
                configuration.delete();
            }
        }
    }

    private JProp getServerProperties() {
        File conf = new File(JProp.getJonasBase(), "conf");
        File jonasPropertyFile = new File(conf, "jonas.properties");
        long currentLastModified = jonasPropertyFile.lastModified();
        if (currentLastModified != this.lastModified) {
            this.serverProperties = new JProp();
            this.lastModified = currentLastModified;
        }
        return this.serverProperties;
    }

    private List<String> removeDuplicateServices(List<String> services) {
        LinkedList<String> result = new LinkedList<String>();
        for (String service : services) {
            if (!result.contains(service)) {
                result.add(service);
                continue;
            }
            this.logger.warn("Service ''{0}'' declared many times in jonas.properties", service);
        }
        return result;
    }
}

