/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.ws;

import java.io.File;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.ow2.jonas.web.tomcat6.JOnASStandardContext;
import org.ow2.jonas.web.tomcat6.Tomcat6Service;
import org.ow2.jonas.web.tomcat6.ws.URLUtils;
import org.ow2.jonas.web.tomcat6.ws.WebServiceEndpointStandardWrapper;
import org.ow2.jonas.ws.jaxws.IWebServiceDeploymentManager;
import org.ow2.jonas.ws.jaxws.IWebServiceEndpoint;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WSDeployment
implements IWebServiceDeploymentManager {
    private static Log logger = LogFactory.getLog(WSDeployment.class);
    private Tomcat6Service tomcatService;
    private String workDirectory;

    public WSDeployment(Tomcat6Service tomcatService) {
        this.tomcatService = tomcatService;
    }

    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    public void registerWSEndpoint(IWebServiceEndpoint endpoint) throws WSException {
        switch (endpoint.getType()) {
            case POJO: {
                throw new IllegalStateException("Not implemented yet");
            }
            case EJB: {
                this.registerEJBEndpoint(endpoint);
            }
        }
    }

    private void registerEJBEndpoint(IWebServiceEndpoint endpoint) throws WSException {
        PortMetaData pmd = endpoint.getPortMetaData();
        Host host = this.tomcatService.findHost(pmd.getHostname());
        WebServiceEndpointStandardWrapper wrapper = null;
        wrapper = new WebServiceEndpointStandardWrapper(endpoint);
        wrapper.setParentClassLoader(this.getClass().getClassLoader());
        logger.debug("Added Wrapper/Servlet: {0}", new Object[]{wrapper});
        JOnASStandardContext context = new JOnASStandardContext(false, true, false);
        context.setPath(URLUtils.getContextRoot(pmd));
        context.addChild((Container)wrapper);
        String pattern = endpoint.getPortMetaData().getUrlPattern();
        context.addServletMapping(pattern, wrapper.getServletName());
        context.setTomcatService(this.tomcatService);
        File docBase = new File(this.workDirectory, endpoint.getPortMetaData().getContextRoot());
        if (!docBase.exists()) {
            docBase.mkdirs();
        }
        context.setDocBase(docBase.getPath());
        context.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
                if ("start".equals(lifecycleEvent.getType())) {
                    Context ctx = (Context)lifecycleEvent.getLifecycle();
                    ctx.setConfigured(true);
                } else if ("after_start".equals(lifecycleEvent.getType())) {
                    String[] listeners;
                    Context ctx = (Context)lifecycleEvent.getLifecycle();
                    for (String listener : listeners = ctx.findApplicationListeners()) {
                        ctx.removeApplicationListener(listener);
                    }
                }
            }
        });
        host.addChild((Container)context);
        String url = URLUtils.getEndpointURL(pmd, host);
        endpoint.getPortMetaData().setEndpointURL(url);
        logger.debug("Added Context: {0}", new Object[]{context});
    }

    public void unregisterWSEndpoint(IWebServiceEndpoint endpoint) throws WSException {
        switch (endpoint.getType()) {
            case POJO: {
                throw new IllegalStateException("Not implemented yet");
            }
            case EJB: {
                this.unregisterEJBEndpoint(endpoint);
            }
        }
    }

    private void unregisterEJBEndpoint(IWebServiceEndpoint endpoint) {
        String contextName = URLUtils.getContextRoot(endpoint.getPortMetaData());
        String hostname = endpoint.getPortMetaData().getHostname();
        Host host = this.tomcatService.findHost(hostname);
        Context context = (Context)host.findChild(contextName);
        String path = context.getDocBase();
        File docBase = new File(path);
        if (docBase.isDirectory()) {
            docBase.delete();
        }
        host.removeChild((Container)context);
        logger.debug("Context {0} stopped", contextName);
    }
}

