/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.builder.webserviceref;

import javax.naming.NamingException;
import javax.naming.Reference;
import org.ow2.util.ee.builder.webserviceref.Constants;
import org.ow2.util.ee.builder.webserviceref.ReferenceHelper;
import org.ow2.util.ee.builder.webserviceref.factory.WebServiceRefObjectFactory;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class WebServiceRefBuilder {
    private static Log logger = LogFactory.getLog(WebServiceRefBuilder.class);

    public Reference build(IJaxwsWebServiceRef serviceRef) throws NamingException {
        if (WebServiceRefBuilder.isNullOrEmpty(serviceRef.getValue())) {
            serviceRef.setValue(serviceRef.getType());
        }
        String referenceClassname = null;
        String serviceClassname = serviceRef.getValue();
        String seiClassname = null;
        if (!serviceRef.getValue().equals(serviceRef.getType())) {
            referenceClassname = serviceRef.getType();
            seiClassname = serviceRef.getType();
            logger.debug("Port injection required (Service:''{0}'', SEI:''{1}'')", serviceClassname, seiClassname);
        } else {
            referenceClassname = serviceRef.getValue();
            logger.debug("Service injection required (Service:''{0}'')", serviceClassname);
        }
        Reference ref = this.createReference(referenceClassname);
        ReferenceHelper helper = new ReferenceHelper(ref);
        helper.insert(Constants.SERVICE_CLASS.name(), serviceClassname);
        helper.insert(Constants.SERVICE_ENDPOINT_INTERFACE.name(), seiClassname);
        helper.insert(Constants.WSDL_LOCATION.name(), serviceRef.getWsdlLocation());
        helper.insert(Constants.SERVICE_REF_ANNOTATION.name(), serviceRef);
        if (serviceRef.getHandlerChains() != null) {
            helper.insert(Constants.HANDLER_CHAIN_STRUCT.name(), serviceRef.getHandlerChains());
            logger.debug("Build ref using handler-chains from descriptor", new Object[0]);
        } else if (serviceRef.getHandlerChainFile() != null) {
            helper.insert(Constants.HANDLER_CHAIN_FILE.name(), serviceRef.getHandlerChainFile());
            helper.insert(Constants.DECLARING_CLASS.name(), serviceRef.getDeclaringClass());
            logger.debug("Build ref using handler-chains from annotation", new Object[0]);
        }
        return ref;
    }

    protected Reference createReference(String classname) {
        return new Reference(classname, WebServiceRefObjectFactory.class.getName(), null);
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || "".equals(value);
    }
}

