/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployer;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployer
implements IDeployer {
    private Log logger = LogFactory.getLog(AbsDeployer.class);
    protected Map<URL, IDeployable<?>> deployedDeployables = new HashMap();

    public abstract void doDeploy(IDeployable<?> var1) throws DeployerException;

    public abstract void doUndeploy(IDeployable<?> var1) throws DeployerException;

    @Override
    public abstract boolean supports(IDeployable<?> var1);

    @Override
    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        this.doDeploy(deployable);
        this.deployedDeployables.put(this.getURL(deployable), deployable);
    }

    @Override
    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        this.doUndeploy(deployable);
        this.deployedDeployables.remove(this.getURL(deployable));
    }

    public void stop() {
        for (IDeployable<?> deployable : new ArrayList(this.deployedDeployables.values())) {
            try {
                this.undeploy(deployable);
            }
            catch (Exception e) {
                this.logger.error("Cannot undeploy the deployable ''{0}''", deployable, e);
            }
        }
    }

    protected URL getURL(IDeployable<?> deployable) throws DeployerException {
        URL url = null;
        try {
            url = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL from deployable '" + deployable + "'.", e);
        }
        return url;
    }

    protected File getFile(IDeployable<?> deployable) throws DeployerException {
        return URLUtils.urlToFile(this.getURL(deployable));
    }

    @Override
    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        return this.deployedDeployables.containsKey(this.getURL(deployable));
    }

    public Map<URL, IDeployable<?>> getDeployedDeployables() {
        return this.deployedDeployables;
    }

    protected void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }
}

