/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class Conventions {
    private static final String PLURAL_SUFFIX = "List";
    private static final Set ignoredInterfaces = new HashSet();

    public static String getVariableName(Object value) {
        Assert.notNull(value, "Value must not be null");
        Class valueClass = null;
        boolean pluralize = false;
        if (value.getClass().isArray()) {
            valueClass = value.getClass().getComponentType();
            pluralize = true;
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                throw new IllegalArgumentException("Cannot generate variable name for an empty Collection");
            }
            Object valueToCheck = Conventions.peekAhead(collection);
            valueClass = Conventions.getClassForValue(valueToCheck);
            pluralize = true;
        } else {
            valueClass = Conventions.getClassForValue(value);
        }
        String name = ClassUtils.getShortNameAsProperty(valueClass);
        return pluralize ? Conventions.pluralize(name) : name;
    }

    public static String attributeNameToPropertyName(String attributeName) {
        Assert.notNull(attributeName, "'attributeName' must not be null");
        if (attributeName.indexOf("-") == -1) {
            return attributeName;
        }
        char[] chars = attributeName.toCharArray();
        char[] result = new char[chars.length - 1];
        int currPos = 0;
        boolean upperCaseNext = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '-') {
                upperCaseNext = true;
                continue;
            }
            if (upperCaseNext) {
                result[currPos++] = Character.toUpperCase(c);
                upperCaseNext = false;
                continue;
            }
            result[currPos++] = c;
        }
        return new String(result, 0, currPos);
    }

    private static Class getClassForValue(Object value) {
        if (Proxy.isProxyClass(value.getClass())) {
            Class<?>[] ifcs = value.getClass().getInterfaces();
            for (int i = 0; i < ifcs.length; ++i) {
                Class<?> ifc = ifcs[i];
                if (ignoredInterfaces.contains(ifc)) continue;
                return ifc;
            }
        }
        return value.getClass();
    }

    private static String pluralize(String name) {
        return name + PLURAL_SUFFIX;
    }

    private static Object peekAhead(Collection collection) {
        Iterator it = collection.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - no element found");
        }
        Object value = it.next();
        if (value == null) {
            throw new IllegalStateException("Unable to peek ahead in non-empty collection - only null element found");
        }
        return value;
    }

    public static String getQualifiedAttributeName(Class enclosingClass, String attributeName) {
        Assert.notNull(enclosingClass, "'enclosingClass' must not be null");
        Assert.notNull(attributeName, "'attributeName' must not be null");
        return enclosingClass.getName() + "." + attributeName;
    }

    static {
        ignoredInterfaces.add(Serializable.class);
        ignoredInterfaces.add(Externalizable.class);
        ignoredInterfaces.add(Cloneable.class);
        ignoredInterfaces.add(Comparable.class);
    }
}

