/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.deployer;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deployer.OsgiRepositoryDeployerImpl;
import org.ow2.util.plan.deployer.api.IDeploymentPlanDeployer;
import org.ow2.util.plan.deployer.api.IRepositoryDeployer;
import org.ow2.util.plan.deployer.impl.DeploymentPlanDeployer;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactoryManager;
import org.ow2.util.plan.monitor.api.IResourceMonitor;
import org.ow2.util.plan.reader.plan.IPlanReader;
import org.ow2.util.plan.reader.repository.IRepositoryDataReader;
import org.ow2.util.plan.repository.api.IRepositoryManager;

public class PlanDeployerActivator
implements BundleActivator,
ServiceListener {
    private Log logger = LogFactory.getLog(PlanDeployerActivator.class);
    private BundleContext bundleContext = null;
    private Class<?>[] services = new Class[]{IPlanReader.class, IResourceFetcherFactoryManager.class, IResourceMonitor.class, IRepositoryDataReader.class, IRepositoryManager.class, IDeployerManager.class};
    private IDeploymentPlanDeployer deploymentPlanDeployer = null;
    private OsgiRepositoryDeployerImpl repositoryDeployer = null;
    private ServiceRegistration deploymentPlanDeployerRegistration = null;
    private ServiceRegistration repositoryDeployerRegistration = null;
    private IDeployerManager deployerManager = null;

    public void start(BundleContext context) throws Exception {
        ServiceReference deployerManagerRef;
        ServiceReference repositoryManagerRef;
        ServiceReference repositoryReaderRef;
        ServiceReference resourceMonitorRef;
        ServiceReference factoriesManagerRef;
        this.bundleContext = context;
        this.deploymentPlanDeployer = new DeploymentPlanDeployer();
        this.repositoryDeployer = new OsgiRepositoryDeployerImpl();
        this.deploymentPlanDeployerRegistration = context.registerService(IDeploymentPlanDeployer.class.getName(), (Object)this.deploymentPlanDeployer, null);
        this.repositoryDeployerRegistration = context.registerService(IRepositoryDeployer.class.getName(), (Object)this.repositoryDeployer, null);
        ServiceReference planReaderRef = context.getServiceReference(IPlanReader.class.getName());
        if (planReaderRef != null) {
            IPlanReader reader = (IPlanReader)context.getService(planReaderRef);
            this.deploymentPlanDeployer.setPlanReader(reader);
            this.logger.debug((Object)"The deployment plan XML reader was set to {0}", new Object[]{reader});
        }
        if ((factoriesManagerRef = context.getServiceReference(IResourceFetcherFactoryManager.class.getName())) != null) {
            IResourceFetcherFactoryManager manager = (IResourceFetcherFactoryManager)context.getService(factoriesManagerRef);
            this.deploymentPlanDeployer.setFetcherFactoryManager(manager);
            this.logger.debug((Object)"The resource fetcher factory manager was set to {0}", new Object[]{manager});
        }
        if ((resourceMonitorRef = context.getServiceReference(IResourceMonitor.class.getName())) != null) {
            IResourceMonitor monitor = (IResourceMonitor)context.getService(resourceMonitorRef);
            this.deploymentPlanDeployer.setResourceMonitor(monitor);
            this.logger.debug((Object)"The resource monitor was set to {0}", new Object[]{monitor});
        }
        if ((repositoryReaderRef = context.getServiceReference(IRepositoryDataReader.class.getName())) != null) {
            IRepositoryDataReader reader = (IRepositoryDataReader)context.getService(repositoryReaderRef);
            this.repositoryDeployer.setReader(reader);
            this.logger.debug((Object)"The repositories file XML reader was set to {0}", new Object[]{reader});
        }
        if ((repositoryManagerRef = context.getServiceReference(IRepositoryManager.class.getName())) != null) {
            IRepositoryManager manager = (IRepositoryManager)context.getService(repositoryManagerRef);
            this.repositoryDeployer.setRepositoryManager(manager);
            this.logger.debug((Object)"The repositories manager was set to {0}", new Object[]{manager});
        }
        if ((deployerManagerRef = context.getServiceReference(IDeployerManager.class.getName())) != null) {
            IDeployerManager deployerManager = (IDeployerManager)context.getService(deployerManagerRef);
            deployerManager.register((IDeployer)this.deploymentPlanDeployer);
            deployerManager.register((IDeployer)this.repositoryDeployer);
            this.deploymentPlanDeployer.setDeployerManager(deployerManager);
            this.deployerManager = deployerManager;
            this.logger.debug((Object)"The deployer manager was set to {0}", new Object[]{deployerManager});
        }
        context.addServiceListener((ServiceListener)this, this.buildListenerString());
    }

    public void stop(BundleContext context) throws Exception {
        this.deployerManager.unregister((IDeployer)this.deploymentPlanDeployer);
        this.deployerManager.unregister((IDeployer)this.repositoryDeployer);
        this.deploymentPlanDeployerRegistration.unregister();
        this.repositoryDeployerRegistration.unregister();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        Object serviceObject = this.bundleContext.getService(serviceRef);
        if (serviceObject instanceof IPlanReader) {
            switch (event.getType()) {
                case 1: {
                    if (this.deploymentPlanDeployer.getPlanReader() != null) break;
                    IPlanReader planReader = (IPlanReader)serviceObject;
                    this.deploymentPlanDeployer.setPlanReader(planReader);
                    this.logger.debug((Object)"The deployment plan XML reader was set to {0}", new Object[]{planReader});
                    break;
                }
                case 4: {
                    this.deploymentPlanDeployer.setPlanReader(null);
                    this.logger.debug((Object)"The deployment plan XML reader was unset", new Object[0]);
                    break;
                }
            }
        }
        if (serviceObject instanceof IResourceFetcherFactoryManager) {
            switch (event.getType()) {
                case 1: {
                    if (this.deploymentPlanDeployer.getFetcherFactoryManager() != null) break;
                    IResourceFetcherFactoryManager resourceFetcherFactoryManager = (IResourceFetcherFactoryManager)serviceObject;
                    this.deploymentPlanDeployer.setFetcherFactoryManager(resourceFetcherFactoryManager);
                    this.logger.debug((Object)"The resource fetcher factory manager was set to {0}", new Object[]{resourceFetcherFactoryManager});
                    break;
                }
                case 4: {
                    this.deploymentPlanDeployer.setFetcherFactoryManager(null);
                    this.logger.debug((Object)"The resource fetcher factory manager was unset", new Object[0]);
                    break;
                }
            }
        }
        if (serviceObject instanceof IResourceMonitor) {
            switch (event.getType()) {
                case 1: {
                    if (this.deploymentPlanDeployer.getResourceMonitor() != null) break;
                    IResourceMonitor resourceMonitor = (IResourceMonitor)serviceObject;
                    this.deploymentPlanDeployer.setResourceMonitor(resourceMonitor);
                    this.logger.debug((Object)"The resource monitor was set to {0}", new Object[]{resourceMonitor});
                    break;
                }
                case 4: {
                    this.deploymentPlanDeployer.setResourceMonitor(null);
                    this.logger.debug((Object)"The resource monitor was unset", new Object[0]);
                    break;
                }
            }
        }
        if (serviceObject instanceof IRepositoryDataReader) {
            switch (event.getType()) {
                case 1: {
                    if (this.repositoryDeployer.getReader() != null) break;
                    IRepositoryDataReader repositoryReader = (IRepositoryDataReader)serviceObject;
                    this.repositoryDeployer.setReader(repositoryReader);
                    this.logger.debug((Object)"The repository XML reader was set to {0}", new Object[]{repositoryReader});
                    break;
                }
                case 4: {
                    this.repositoryDeployer.setReader(null);
                    this.logger.debug((Object)"The repository XML reader was unset", new Object[0]);
                    break;
                }
            }
        }
        if (serviceObject instanceof IRepositoryManager) {
            switch (event.getType()) {
                case 1: {
                    if (this.repositoryDeployer.getRepositoryManager() != null) break;
                    IRepositoryManager repositoryManager = (IRepositoryManager)serviceObject;
                    this.repositoryDeployer.setRepositoryManager(repositoryManager);
                    this.logger.debug((Object)"The repository manager was set to {0}", new Object[]{repositoryManager});
                    break;
                }
                case 4: {
                    this.repositoryDeployer.setRepositoryManager(null);
                    this.logger.debug((Object)"The repository manager was unset", new Object[0]);
                    break;
                }
            }
        }
        if (serviceObject instanceof IDeployerManager) {
            switch (event.getType()) {
                case 1: {
                    if (this.deployerManager != null) break;
                    this.deployerManager = (IDeployerManager)serviceObject;
                    this.logger.debug((Object)"The deployer manager was set to {0}", new Object[]{this.deployerManager});
                    break;
                }
                case 4: {
                    this.deployerManager = null;
                    this.logger.debug((Object)"The deployer manager was unset", new Object[0]);
                    break;
                }
            }
        }
    }

    private String buildListenerString() {
        StringBuilder sb = new StringBuilder("(|");
        for (Class<?> clazz : this.services) {
            sb.append(this.buildListenerStringForService(clazz.getName()));
        }
        sb.append(")");
        return sb.toString();
    }

    private String buildListenerStringForService(String service) {
        StringBuilder sb = new StringBuilder("(");
        sb.append("objectClass");
        sb.append("=");
        sb.append(service);
        sb.append(")");
        return sb.toString();
    }
}

