/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.extensions.soap.SoapBody;

public class RPCOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(RPCOutInterceptor.class);

    public RPCOutInterceptor() {
        super("marshal");
    }

    public void handleMessage(Message message) {
        try {
            NSStack nsStack = new NSStack();
            nsStack.push();
            BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class.getName());
            assert (operation.getName() != null);
            XMLStreamWriter xmlWriter = this.getXMLStreamWriter(message);
            List<MessagePartInfo> parts = null;
            if (!this.isRequestor(message)) {
                parts = operation.getOutput().getMessageParts();
                this.addOperationNode(nsStack, message, xmlWriter, true, operation);
            } else {
                parts = operation.getInput().getMessageParts();
                this.addOperationNode(nsStack, message, xmlWriter, false, operation);
            }
            MessageContentsList objs = MessageContentsList.getContentsList(message);
            if (objs == null) {
                return;
            }
            for (MessagePartInfo part : parts) {
                Object o;
                if (!objs.hasValue(part) || (o = objs.get(part)) != null) continue;
                throw new Fault(new org.apache.cxf.common.i18n.Message("BP_2211_RPCLIT_CANNOT_BE_NULL", LOG, part.getConcreteName()));
            }
            this.writeParts(message, message.getExchange(), operation, objs, parts);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }

    protected String addOperationNode(NSStack nsStack, Message message, XMLStreamWriter xmlWriter, boolean output, BindingOperationInfo boi) throws XMLStreamException {
        String responseSuffix = output ? "Response" : "";
        String ns = boi.getName().getNamespaceURI();
        SoapBody body = null;
        body = output ? boi.getOutput().getExtensor(SoapBody.class) : boi.getInput().getExtensor(SoapBody.class);
        if (body != null && !StringUtils.isEmpty(body.getNamespaceURI())) {
            ns = body.getNamespaceURI();
        }
        nsStack.add(ns);
        String prefix = nsStack.getPrefix(ns);
        StaxUtils.writeStartElement(xmlWriter, prefix, boi.getName().getLocalPart() + responseSuffix, ns);
        return ns;
    }

    protected XMLStreamWriter getXMLStreamWriter(Message message) {
        return message.getContent(XMLStreamWriter.class);
    }
}

