/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.net.URL;
import org.apache.cxf.message.Message;

public abstract class HttpBasicAuthSupplier {
    protected String logicalName;

    protected HttpBasicAuthSupplier() {
        this.logicalName = this.getClass().getName();
    }

    protected HttpBasicAuthSupplier(String name) {
        this.logicalName = name;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    protected UserPass createUserPass(String userid, String password) {
        return new UserPass(userid, password);
    }

    public abstract UserPass getPreemptiveUserPass(String var1, URL var2, Message var3);

    public abstract UserPass getUserPassForRealm(String var1, URL var2, Message var3, String var4);

    public static final class UserPass {
        private final String userid;
        private final String password;

        UserPass(String user, String pass) {
            if (user.contains(":")) {
                throw new IllegalArgumentException("The argument \"user\" cannot contain ':'.");
            }
            this.userid = user;
            this.password = pass;
        }

        public String getUserid() {
            return this.userid;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

