/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.generator;

import org.apache.velocity.context.Context;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.generator.api.MOP;
import org.objectweb.jorm.generator.lib.NamingFilterExpressionHelper;
import org.objectweb.jorm.mapper.rdb.generator.RdbCommonHelper;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenInfos;
import org.objectweb.jorm.mapper.rdb.lib.RdbExtentGenInfos;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class RdbMappingMOP
extends RdbCommonHelper
implements MOP {
    public RdbMappingMOP(Logger logger) {
        super(logger);
    }

    public boolean isInPK(PrimitiveElementMapping pem) {
        return false;
    }

    public void initContext(Context ctx, Class clazz, String projectName, String mapperName) throws PException {
        ctx.put("rdbTools", this);
        String mn = (String)ctx.get("mappername");
        ctx.put("adapter", this.getRdbAdapter(mn));
        ctx.put("G", "\"");
        RdbGenInfos rdbGenInfos = this.getRdbGenInfos(clazz, projectName, mapperName);
        ctx.put("genInfos", rdbGenInfos);
        ctx.put("extentGenInfos", new RdbExtentGenInfos(this.logger));
        if (clazz.isPolymorphic()) {
            PolymorphicFilterExpressionHelper mi = null;
            try {
                NameDef nd = clazz.getClassMapping(projectName, mapperName).getIdentifierMapping().getNameDef();
                Class classToLookForExpression = (Class)nd.getParent();
                Expression exp = classToLookForExpression.getInheritanceFilter(nd);
                exp.compileExpression();
                mi = new PolymorphicFilterExpressionHelper(exp, this.logger);
            }
            catch (ExpressionException e) {
                throw new PException((Exception)((Object)e));
            }
            ctx.put("mi", (Object)mi);
        }
    }

    public String[] getTemplateLibraries() {
        String[] libs = new String[]{"org/objectweb/jorm/mapper/rdb/generator/RdbMapping.vm", "org/objectweb/jorm/mapper/rdb/generator/RdbExtentDefinition.vm"};
        return libs;
    }

    private String getStrAsObject(String str, PType type) {
        switch (type.getTypeCode()) {
            case 2: 
            case 10: {
                return "new Byte(" + str + ")";
            }
            case 1: 
            case 9: {
                return "new Character(" + str + ")";
            }
            case 3: 
            case 11: {
                return "new Short(" + str + ")";
            }
            case 4: 
            case 12: {
                return "new Integer(" + str + ")";
            }
            case 5: 
            case 13: {
                return "new Long(" + str + ")";
            }
        }
        return str;
    }

    private String getTupleType(PType type) {
        switch (type.getTypeCode()) {
            case 17: {
                return "Date";
            }
            case 16: {
                return "String";
            }
            case 18: {
                return "CharArray";
            }
            case 19: {
                return "ByteArray";
            }
            case 22: {
                return "BigDecimal";
            }
            case 21: {
                return "BigInteger";
            }
            case 2: {
                return "Byte";
            }
            case 1: {
                return "Char";
            }
            case 3: {
                return "Short";
            }
            case 4: {
                return "Int";
            }
            case 5: {
                return "Long";
            }
        }
        return "Object";
    }

    public class PolymorphicFilterExpressionHelper
    extends NamingFilterExpressionHelper {
        private PType filterType;

        public PolymorphicFilterExpressionHelper(Expression e, Logger logger) throws PException, ExpressionException {
            super(logger);
            this.filterType = e.getType();
            this.fillMatchInfo(e);
        }

        public String getFilter() {
            return RdbMappingMOP.this.getStrAsObject(super.getFilter(), this.filterType);
        }

        protected void fillMatchInfo(ParameterOperand po) throws PException, ExpressionException {
            this.logger.log(BasicLevel.DEBUG, (Object)("ParameterOperand " + po.getName()));
            if (this.field2declarations.get(po.getName()) == null) {
                StringBuffer declaration = new StringBuffer();
                declaration.append(po.getType().getJavaName());
                declaration.append(' ');
                declaration.append(po.getName());
                declaration.append(" = (");
                declaration.append(po.getType().getJavaName());
                declaration.append(") tuple.get");
                declaration.append(RdbMappingMOP.this.getTupleType(po.getType()));
                declaration.append("(fieldRank");
                declaration.append(")");
                declaration.append(";");
                this.field2declarations.put(po.getName(), declaration);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Add declaration: " + declaration));
                }
            }
            this.filter.append(po.getName());
        }
    }
}

