/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal.cm;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.dbm.internal.cm.JManagedConnection;
import org.ow2.jonas.lib.util.Log;

public class JConnection
implements Connection {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.dbm.con");
    protected Connection actConn = null;
    protected JManagedConnection xac = null;
    protected boolean autocommit_set = false;
    protected boolean autocommit_unset = false;

    public JConnection(JManagedConnection xac, Connection actual) {
        this.xac = xac;
        this.actConn = actual;
    }

    public Connection getConnection() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.actConn;
    }

    public Statement createStatement() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.createStatement();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)sql);
        try {
            return this.xac.prepareStatement(sql);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.prepareCall(sql);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public boolean isPhysicallyClosed() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        return this.actConn.isClosed();
    }

    public boolean isClosed() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        return this.xac.isClosed();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.getMetaData();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.actConn.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public boolean isReadOnly() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.isReadOnly();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.actConn.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public String getCatalog() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.getCatalog();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void close() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.xac.notifyClose();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.actConn.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.getWarnings();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void clearWarnings() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.actConn.clearWarnings();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void commit() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"local transaction");
        try {
            this.actConn.commit();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void rollback() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"local transaction");
        try {
            this.actConn.rollback();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            if (!autoCommit) {
                if (!this.autocommit_unset) {
                    this.actConn.setAutoCommit(false);
                    this.autocommit_set = false;
                    this.autocommit_unset = true;
                }
            } else if (!this.autocommit_set) {
                this.actConn.setAutoCommit(true);
                this.autocommit_set = true;
                this.autocommit_unset = false;
            }
        }
        catch (SQLException e) {
            String s = e.getMessage().toLowerCase();
            if (s.indexOf("set chained command not allowed") != -1) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"failed...");
                    logger.log(BasicLevel.DEBUG, (Object)"Committing then retrying");
                }
                try {
                    this.actConn.commit();
                    this.actConn.setAutoCommit(autoCommit);
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"succeeded after retry");
                    }
                }
                catch (SQLException se) {
                    logger.log(BasicLevel.ERROR, (Object)("" + autoCommit + ") failed again after retry"), (Throwable)se);
                    this.xac.notifyError(e);
                    throw e;
                }
            }
            logger.log(BasicLevel.ERROR, (Object)("setAutoCommit(" + autoCommit + ") failed: " + e));
            this.xac.notifyError(e);
            throw e;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.actConn.getAutoCommit();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.getTypeMap();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.actConn.setTypeMap(map);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)sql);
        try {
            return this.xac.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public int getHoldability() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.getHoldability();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)sql);
        try {
            return this.actConn.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)sql);
        try {
            return this.actConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)sql);
        try {
            return this.actConn.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)sql);
        try {
            return this.actConn.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.actConn.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.actConn.rollback(savepoint);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.actConn.setHoldability(holdability);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.setSavepoint();
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            return this.actConn.setSavepoint(name);
        }
        catch (SQLException e) {
            this.xac.notifyError(e);
            throw e;
        }
    }
}

