/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.MessageInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class BufferedMessageInputStream
extends MessageInputStream {
    protected InputStream in = null;

    public BufferedMessageInputStream() {
        this(8192);
    }

    public BufferedMessageInputStream(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
        this.pos = 0;
        this.count = 0;
    }

    protected final void clean() {
        this.pos = 0;
        this.count = 0;
    }

    private final void fill() throws IOException {
        if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)"fill()");
        }
        this.pos = 0;
        this.count = this.in.read(this.buf, 0, this.buf.length);
        if (this.count < 0) {
            this.count = 0;
        }
        if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("fill() - count=" + this.count));
        }
    }

    public final int read() throws IOException {
        if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)"read()");
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("read(" + len + ')'));
        }
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        do {
            int nread;
            if ((nread = this.read1(b, off + n, len - n)) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while (this.in == null || this.in.available() > 0);
        return n;
    }

    private final int read1(byte[] b, int off, int len) throws IOException {
        int avail;
        if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("read1(" + len + ')'));
        }
        if ((avail = this.count - this.pos) <= 0) {
            if (len >= this.buf.length) {
                if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("returns read(" + len + ')'));
                }
                return this.in.read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("read1() returns " + cnt));
        }
        return cnt;
    }

    protected final void readFully(int length) throws IOException {
        int valid;
        if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("readFully(" + length + ')'));
        }
        if ((valid = this.count - this.pos) < length) {
            if (length > this.buf.length) {
                byte[] newbuf = new byte[length];
                System.arraycopy(this.buf, this.pos, newbuf, 0, valid);
                this.buf = newbuf;
                this.pos = 0;
                this.count = valid;
            } else if (this.pos + length > this.buf.length) {
                System.arraycopy(this.buf, this.pos, this.buf, 0, valid);
                this.pos = 0;
                this.count = valid;
            }
            do {
                int nb;
                if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("read(" + this.count + ')'));
                }
                if ((nb = this.in.read(this.buf, this.count, this.buf.length - this.count)) < 0) {
                    throw new EOFException();
                }
                this.count += nb;
            } while (this.count < length);
        }
        if (BufferedMessageInputStream.getLogger().isLoggable(BasicLevel.DEBUG)) {
            BufferedMessageInputStream.getLogger().log(BasicLevel.DEBUG, (Object)("readFully returns - count=" + this.count));
        }
    }
}

