/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import java.io.Serializable;
import java.util.Vector;
import org.objectweb.joram.mom.proxies.ProxyMessage;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.util.monolog.api.BasicLevel;

public class AckedQueue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector list = new Vector();
    private int current = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(ProxyMessage msg) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("AckedQueue.push(" + msg + ')'));
        }
        Vector vector = this.list;
        synchronized (vector) {
            this.list.addElement(msg);
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyMessage get() throws InterruptedException {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"AckedQueue.get()");
        }
        Vector vector = this.list;
        synchronized (vector) {
            while (this.list.size() - this.current == 0) {
                this.list.wait();
            }
            ProxyMessage msg = (ProxyMessage)this.list.elementAt(this.current);
            ++this.current;
            return msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(long ackId) {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("AckedQueue.ack(" + ackId + ')'));
        }
        Vector vector = this.list;
        synchronized (vector) {
            while (this.list.size() > 0) {
                ProxyMessage m = (ProxyMessage)this.list.elementAt(0);
                if (ackId < m.getId()) {
                    return;
                }
                if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("AckedQueue acked " + m.getId()));
                }
                this.list.removeElementAt(0);
                if (this.current <= 0) continue;
                --this.current;
            }
        }
    }

    public void reset() {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)"AckedQueue.reset()");
        }
        this.current = 0;
    }
}

