/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJBDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.metadata.common.impl.AbsDeployableMetadataFactory;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarClassMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarFieldMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.IEjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IApplicationException;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IAssemblyDescriptor;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEJB3;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEnterpriseBeans;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptors;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IMessageDriven;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.ISession;
import org.ow2.util.ee.metadata.ejbjar.impl.configurator.EjbJarDeployableMetadataConfigurator;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.helper.EjbJarMetadataMerge;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing.EJB3DeploymentDesc;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EJB3;
import org.ow2.util.ee.metadata.ws.api.IWebservicesCommonClassMetadata;
import org.ow2.util.ee.metadata.ws.api.xml.merge.IClassMetadataFinder;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IWebservices;
import org.ow2.util.ee.metadata.ws.impl.xml.merge.WebservicesMetadataMerger;
import org.ow2.util.ee.metadata.ws.impl.xml.parsing.Webservices12DeploymentDesc;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.IClassesLocator;
import org.ow2.util.scan.api.IScanner;
import org.ow2.util.scan.api.classlocator.ArchiveClassesLocator;
import org.ow2.util.scan.api.classlocator.ClassLoaderClassesLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EjbJarDeployableMetadataFactory<E extends EJBDeployable<E>, D extends IEjbJarDeployableMetadata<E, D, C, M, F>, C extends IEjbJarClassMetadata<E, D, C, M, F>, M extends IEjbJarMethodMetadata<E, D, C, M, F>, F extends IEjbJarFieldMetadata<E, D, C, M, F>>
extends AbsDeployableMetadataFactory
implements IEjbJarDeployableMetadataFactory<E, D, C, M, F> {
    private static final Log LOGGER = LogFactory.getLog(EjbJarDeployableMetadataFactory.class);

    public EjbJarDeployableMetadataFactory() {
    }

    public EjbJarDeployableMetadataFactory(IScanner scanner) {
        super(scanner);
    }

    public D createDeployableMetadata(E ejbDeployable) throws DeployableMetadataException {
        return this.createDeployableMetadata(ejbDeployable, (List<IClassesLocator>)null);
    }

    public D createDeployableMetadata(E deployable, ClassLoader classLoader) throws DeployableMetadataException {
        List<ClassLoaderClassesLocator> classesLocatorList = null;
        classesLocatorList = classLoader != null ? Arrays.asList(new ClassLoaderClassesLocator(classLoader)) : Arrays.asList(new ClassLoaderClassesLocator(ClassLoader.getSystemClassLoader()));
        return this.createDeployableMetadata(deployable, classesLocatorList);
    }

    private void completeClassList(EJB3 ejb3, Set<String> classNameSet) {
        if (ejb3 != null) {
            List applicationExceptionList;
            IAssemblyDescriptor assemblyDescriptor;
            List interceptorList;
            IInterceptors interceptors;
            IEnterpriseBeans enterpriseBeans = ejb3.getEnterpriseBeans();
            if (enterpriseBeans != null) {
                List sessionList = enterpriseBeans.getSessionList();
                for (ISession session : sessionList) {
                    this.addClassToSetIfNotNull(session.getEjbClass(), classNameSet);
                }
                List messageDrivenList = enterpriseBeans.getMessageDrivenList();
                for (IMessageDriven messageDriven : messageDrivenList) {
                    this.addClassToSetIfNotNull(messageDriven.getEjbClass(), classNameSet);
                }
            }
            if ((interceptors = ejb3.getInterceptors()) != null && (interceptorList = interceptors.getInterceptorList()) != null) {
                for (IInterceptor interceptor : interceptorList) {
                    this.addClassToSetIfNotNull(interceptor.getInterceptorClass(), classNameSet);
                }
            }
            if ((assemblyDescriptor = ejb3.getAssemblyDescriptor()) != null && (applicationExceptionList = assemblyDescriptor.getApplicationExceptionList()) != null) {
                for (IApplicationException applicationException : applicationExceptionList) {
                    this.addClassToSetIfNotNull(applicationException.getClassName(), classNameSet);
                }
            }
        }
    }

    protected abstract EjbJarDeployableMetadataConfigurator<E, D, C, M, F> createEjbJarDeployableMetadataConfigurator(E var1);

    protected abstract D createEjbJaDeployableMetadata(E var1);

    public D createDeployableMetadata(E ejb3Deployable, List<? extends IClassesLocator> ejbJarExternLibraries) throws DeployableMetadataException {
        EJB3 ejb3;
        long tAnalyzeStart = System.currentTimeMillis();
        IArchive archive = ejb3Deployable.getArchive();
        try {
            ejb3 = EJB3DeploymentDesc.getEjb3(archive);
        }
        catch (ParsingException e) {
            throw new DeployableMetadataException((Throwable)e);
        }
        IWebservices webservices = null;
        try {
            webservices = Webservices12DeploymentDesc.getWebservices12((IArchive)archive, (Webservices12DeploymentDesc.Type)Webservices12DeploymentDesc.Type.EJBJAR);
        }
        catch (ParsingException e) {
            throw new DeployableMetadataException((Throwable)e);
        }
        EjbJarDeployableMetadataConfigurator<E, D, C, M, F> ejbJarArchiveMetadataConfigurator = this.createEjbJarDeployableMetadataConfigurator(ejb3Deployable);
        HashSet<String> classNameSet = new HashSet<String>();
        this.beforeScan(ejbJarArchiveMetadataConfigurator.getEjbJarArchiveMetadata());
        if (ejb3 != null && ejb3.isMetadataComplete()) {
            ejbJarArchiveMetadataConfigurator.setAnnotationParsingDesactived(true);
        } else {
            Iterator entryIterator;
            ejbJarArchiveMetadataConfigurator.setAnnotationParsingDesactived(false);
            try {
                entryIterator = archive.getEntries();
            }
            catch (ArchiveException e) {
                throw new DeployableMetadataException((Throwable)e);
            }
            while (entryIterator.hasNext()) {
                String entry = (String)entryIterator.next();
                if (!entry.endsWith(".class")) continue;
                classNameSet.add(entry.substring(0, entry.length() - ".class".length()));
            }
        }
        this.completeClassList(ejb3, classNameSet);
        this.scan(classNameSet, (IClassesLocator)new ArchiveClassesLocator(archive), ejbJarExternLibraries, ejbJarArchiveMetadataConfigurator);
        D ejbJarArchiveMetadata = ejbJarArchiveMetadataConfigurator.getEjbJarArchiveMetadata();
        ejbJarArchiveMetadata.setEjb3((IEJB3)ejb3);
        ejbJarArchiveMetadata.setWebservices12(webservices);
        this.afterScan(ejbJarArchiveMetadata);
        EjbJarMetadataMerge.merge(ejbJarArchiveMetadata);
        WebservicesMetadataMerger.merge(ejbJarArchiveMetadata, (IClassMetadataFinder)new IClassMetadataFinder((IEjbJarDeployableMetadata)ejbJarArchiveMetadata){
            final /* synthetic */ IEjbJarDeployableMetadata val$ejbJarArchiveMetadata;
            {
                this.val$ejbJarArchiveMetadata = iEjbJarDeployableMetadata;
            }

            public IWebservicesCommonClassMetadata findClassMetadata(String link) {
                return this.val$ejbJarArchiveMetadata.getEjbJarClassMetadataForEjbName(link);
            }
        });
        this.afterMerge(ejbJarArchiveMetadata);
        if (LOGGER.isDebugEnabled()) {
            long tAnalyzeStartEnd = System.currentTimeMillis();
            LOGGER.debug((Object)"Analyze of file {0} took {1} ms.", new Object[]{archive.getName(), tAnalyzeStartEnd - tAnalyzeStart});
        }
        return ejbJarArchiveMetadata;
    }

    public Class<D> getDeployableMetadataClass() {
        return IEjbJarDeployableMetadata.class;
    }

    public void beforeScan(D ejbJarArchiveMetadata) {
    }

    public void afterScan(D ejbJarArchiveMetadata) {
    }

    public void afterMerge(D ejbJarArchiveMetadata) {
    }
}

