/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.awt.Checkbox;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jacorb.imr.util.ImRModel;

public class RefreshWindow
extends JFrame
implements ActionListener {
    private JTextField m_interval_tf;
    private JButton m_ok_btn;
    private JButton m_cancel_btn;
    private Checkbox m_disable_box;
    private ImRModel m_model;

    public RefreshWindow(ImRModel imRModel) {
        super("Refresh Interval Settings");
        this.m_model = imRModel;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Enter an Interval (in ms):");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.m_interval_tf = new JTextField("" + this.m_model.m_current_refresh_interval, 10);
        this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.m_interval_tf, gridBagConstraints);
        jPanel.add(this.m_interval_tf);
        this.m_disable_box = new Checkbox("Disable automatic refresh");
        this.m_disable_box.setState(this.m_model.m_refresh_disabled);
        this.buildConstraints(gridBagConstraints, 0, 2, 2, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.m_disable_box, gridBagConstraints);
        jPanel.add(this.m_disable_box);
        this.m_ok_btn = new JButton("OK");
        this.m_ok_btn.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.m_ok_btn, gridBagConstraints);
        jPanel.add(this.m_ok_btn);
        this.m_cancel_btn = new JButton("Cancel");
        this.m_cancel_btn.addActionListener(this);
        this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.m_cancel_btn, gridBagConstraints);
        jPanel.add(this.m_cancel_btn);
        jPanel.setLayout(gridBagLayout);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setVisible(true);
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.m_cancel_btn) {
            this.dispose();
        } else if (jButton == this.m_ok_btn) {
            this.dispose();
            if (this.m_disable_box.getState()) {
                this.m_model.disableRefresh();
            } else {
                this.m_model.setRefreshInterval(Integer.parseInt(this.m_interval_tf.getText()));
            }
        }
    }
}

