/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;

public class PostgresAdapter
extends BasicRdbAdapter {
    private static final String POSTGRESCONCAT = "||";

    public PostgresAdapter() {
        super("postgres");
    }

    public boolean supportBatchPreparedStatement() {
        return false;
    }

    public String getSqlType(int typeCode, boolean usedInPK, int size, int scale) throws RdbAdapterException {
        switch (typeCode) {
            case 0: 
            case 8: {
                return "BOOL";
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                return "INT2";
            }
            case 4: 
            case 12: {
                return "INT4";
            }
            case 5: 
            case 13: {
                return "INT8";
            }
            case 7: 
            case 15: {
                return "FLOAT8";
            }
            case 19: 
            case 20: {
                return "BYTEA";
            }
            case 21: 
            case 22: {
                if (size != -1) {
                    if (scale != -1) {
                        return "DECIMAL(" + size + ", " + scale + ")";
                    }
                    return "DECIMAL(" + size + ")";
                }
                return "DECIMAL";
            }
            case 17: {
                return "TIMESTAMP(3)  without time zone";
            }
        }
        return super.getSqlType(typeCode, usedInPK, size, scale);
    }

    public String getValueAsSQLString(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    public String getValueAsSQLString(Object value, int typeCode) {
        if (value == null) {
            return null;
        }
        switch (typeCode) {
            case 0: 
            case 8: {
                return this.getValueAsSQLString((Boolean)value);
            }
        }
        return super.getValueAsSQLString(value, typeCode);
    }

    public void escapeFunctionOpen(StringBuffer sb) {
    }

    public void escapeFunctionClose(StringBuffer sb) {
    }

    public String getConcatExpression(String op1, String op2) {
        StringBuffer sb = new StringBuffer();
        return sb.append(op1).append(POSTGRESCONCAT).append(op2).toString();
    }

    public String getFirstLocateExpression(String substring, String instring) {
        return "position(" + substring + " in " + instring + ")";
    }

    public String getIndexedLocateExpression(String instring, String substring, String fromIndex) throws RdbAdapterException {
        return "position(" + substring + " in " + "substring(" + instring + " from " + fromIndex + "))";
    }

    public int fetchResultSetSize(ResultSet rs) throws SQLException {
        return -1;
    }

    public boolean existSequence(Connection connection, String seqName) throws SQLException {
        return this.existRelation(connection, seqName, new String[]{"SEQUENCE"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existRelation(Connection connection, String relName, String[] relationTypes) throws SQLException {
        boolean existtable = false;
        ResultSet rs = null;
        if (relationTypes == null) {
            relationTypes = new String[]{"TABLE", "VIEW"};
        }
        String schema = null;
        if (relName.indexOf(46) != -1) {
            schema = relName.substring(0, relName.indexOf(46));
            relName = relName.substring(relName.indexOf(46) + 1);
        }
        try {
            rs = connection.getMetaData().getTables(null, schema, null, relationTypes);
            while (rs.next() && !existtable) {
                existtable = relName.equalsIgnoreCase(rs.getString(3));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return existtable;
    }

    public String getSubqueryAlias() {
        return "foo";
    }

    protected void modifySelectClauseWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
    }

    protected void modifyQueryWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
        if (rangeStart) {
            sb.append(" OFFSET ?");
        }
        if (rangeSize) {
            sb.append(" LIMIT ?");
        }
    }

    public int getRangeParametersAtStart() {
        return 1;
    }

    public String getArrayValueAsSQLStringBegin() {
        return "'{";
    }

    public String getArrayValueAsSQLStringEnd() {
        return "}'";
    }

    public String getArrayElementAsSQLString(Object elem, int elemTypeCode) {
        switch (elemTypeCode) {
            case 16: {
                return elem.toString();
            }
        }
        return super.getArrayElementAsSQLString(elem, elemTypeCode);
    }
}

