/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import java.util.Map;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;

public class BasicParameterOperand
extends BasicVariableOperand
implements ParameterOperand {
    private static final long serialVersionUID = -872018672777162283L;
    protected String name = null;

    public BasicParameterOperand() {
    }

    public BasicParameterOperand(BasicParameterOperand po) {
        super(po);
        this.name = po.getName();
    }

    public BasicParameterOperand(PType type, String name) {
        super(type);
        this.name = name;
    }

    public BasicParameterOperand(PType type, String name, Object value) {
        super(type);
        this.name = name;
        this.objectValue = value;
    }

    public BasicParameterOperand(PType type, String name, String value) {
        super(type);
        this.name = name;
        this.objectValue = value;
    }

    public BasicParameterOperand(PType type, String name, boolean value) {
        super(type);
        this.name = name;
        this.longValue = value ? 1 : 0;
    }

    public BasicParameterOperand(PType type, String name, long value) {
        super(type);
        this.name = name;
        this.longValue = value;
    }

    public BasicParameterOperand(PType type, String name, double value) {
        super(type);
        this.name = name;
        this.doubleValue = value;
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        ((BasicParameterOperand)clone).name = this.name;
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        int i;
        for (i = 0; i < pos.length && pos[i].getType().getTypeCode() != this.type.getTypeCode() && !pos[i].getName().equalsIgnoreCase(this.name); ++i) {
        }
        if (i < pos.length) {
            switch (this.type.getTypeCode()) {
                case 0: {
                    this.setValue(pos[i].getBoolean());
                    break;
                }
                case 2: {
                    this.setValue(pos[i].getByte());
                    break;
                }
                case 1: {
                    this.setValue(pos[i].getChar());
                    break;
                }
                case 17: {
                    this.setValue(pos[i].getDate());
                    break;
                }
                case 7: {
                    this.setValue(pos[i].getDouble());
                    break;
                }
                case 6: {
                    this.setValue(pos[i].getFloat());
                    break;
                }
                case 4: {
                    this.setValue(pos[i].getInt());
                    break;
                }
                case 5: {
                    this.setValue(pos[i].getLong());
                    break;
                }
                case 3: {
                    this.setValue(pos[i].getShort());
                    break;
                }
                case 16: {
                    this.setValue(pos[i].getString());
                    break;
                }
                default: {
                    this.objectValue = pos[i].getObject();
                    break;
                }
            }
        } else {
            throw new ExpressionException("Parameter without value: " + this.getName());
        }
        return this;
    }
}

