/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.expression.lib;

import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.expression.api.BinaryOperator;
import org.objectweb.medor.expression.api.CalculatedParameterOperand;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.IExpressionPrinter;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.UnaryOperator;

public class ExpressionPrinter
implements IExpressionPrinter {
    private static IExpressionPrinter[] printers = new IExpressionPrinter[]{new ExpressionPrinter()};

    public static synchronized void registerPrinter(IExpressionPrinter p) {
        if (p == null) {
            throw new IllegalArgumentException("Null IExpressionPrinter is not allowed");
        }
        IExpressionPrinter[] neo = new IExpressionPrinter[printers.length + 1];
        System.arraycopy(printers, 0, neo, 0, printers.length);
        neo[ExpressionPrinter.printers.length] = p;
    }

    public static String e2str(Expression e) {
        String res = null;
        for (int i = 0; i < printers.length && res == null; ++i) {
            res = printers[i].expToString(e);
        }
        return res == null ? "" : res;
    }

    public String expToString(Expression e) {
        if (e instanceof Operand) {
            PType type = e.getType();
            if (e instanceof ParameterOperand) {
                return (e instanceof CalculatedParameterOperand ? "CalculatedParam(" : "Param(") + ((ParameterOperand)e).getName() + ", " + (type == null ? "nullType" : type.getJormName()) + ", " + e.toString() + ")";
            }
            return e.toString();
        }
        if (e instanceof BinaryOperator) {
            BinaryOperator bo = (BinaryOperator)e;
            return "(" + ExpressionPrinter.e2str(bo.getExpression(0)) + " " + bo.getOperatorString() + " " + ExpressionPrinter.e2str(bo.getExpression(1)) + ")";
        }
        if (e instanceof UnaryOperator) {
            UnaryOperator uo = (UnaryOperator)e;
            return uo.getOperatorString() + "(" + ExpressionPrinter.e2str(uo.getExpression(0)) + ")";
        }
        if (e instanceof Operator) {
            Operator op = (Operator)e;
            StringBuffer s = new StringBuffer();
            s.append(op.getOperatorString());
            s.append("(");
            String sep = "";
            for (int i = 0; i < op.getOperandNumber(); ++i) {
                s.append(sep);
                sep = ", ";
                s.append(ExpressionPrinter.e2str(op.getExpression(i)));
            }
            s.append(")");
            return s.toString();
        }
        return null;
    }
}

