/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.jorm;

import java.util.ArrayList;
import java.util.Iterator;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.lib.JormPathHelper;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.GenClassMapping;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.naming.api.PNameCoder;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.lib.BasicOperand;
import org.objectweb.medor.expression.lib.BasicParameterOperand;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.jorm.api.JormExtent;
import org.objectweb.medor.query.jorm.lib.ClassExtent;
import org.objectweb.medor.query.jorm.lib.GenClassExtent;
import org.objectweb.medor.query.jorm.lib.PNameField;
import org.objectweb.medor.type.lib.PTypeSpaceMedor;
import org.objectweb.util.monolog.api.BasicLevel;

public abstract class JormRule
extends BasicRule {
    public JormRule(String suffix) {
        super(suffix);
    }

    protected PrimitiveElement getPrimitiveElement(JormExtent extent, String fieldname) throws MedorException {
        PrimitiveElement te = null;
        if (extent.getMetaObject() instanceof Class) {
            Class clazz = (Class)extent.getMetaObject();
            te = (PrimitiveElement)clazz.getTypedElement(fieldname);
            if (te == null) {
                te = clazz.getHiddenField(fieldname);
            }
            if (te == null) {
                String msg = "No field " + fieldname + " available on the class " + clazz.getFQName();
                this.log.log(BasicLevel.ERROR, (Object)msg);
                throw new MedorException(msg);
            }
        } else if (extent.getMetaObject() instanceof GenClassRef) {
            GenClassRef gcr = (GenClassRef)extent.getMetaObject();
            te = gcr.getHiddenField(fieldname);
            if (te == null) {
                String msg = "No field " + fieldname + " available on the generic class " + gcr.getGenClassId();
                this.log.log(BasicLevel.ERROR, (Object)msg);
                throw new MedorException(msg);
            }
        } else {
            throw new MedorException("unmanaged jorm extent: " + extent);
        }
        return te;
    }

    protected PrimitiveElementMapping getPEM(JormExtent extent, String fieldName) throws MedorException {
        PrimitiveElementMapping res = null;
        String pn = extent.getProjectName();
        String mn = extent.getPMapper().getMapperName();
        if (extent instanceof ClassExtent) {
            String jormFieldName;
            Class clazz = (Class)extent.getMetaObject();
            ClassMapping cm = this.getClassMapping(extent);
            res = cm.getPrimitiveElementMapping(jormFieldName = this.getJORMFieldName(fieldName, extent));
            if (res == null) {
                Object pcm;
                ArrayList pcms = new ArrayList(cm.getParentClassMappings());
                while (!pcms.isEmpty() && res == null) {
                    pcm = (ParentClassMapping)pcms.remove(0);
                    ClassMapping _cm = pcm.getMOClass().getClassProject(pcm.getProjectName()).getMapping(pcm.getMapperName()).getClassMapping();
                    res = _cm.getPrimitiveElementMapping(jormFieldName);
                    if (res != null) continue;
                    pcms.addAll(_cm.getParentClassMappings());
                }
                if (res == null) {
                    pcm = extent.getPMapper().lookup(clazz.getFQName());
                    try {
                        PClassMapping[] childrenPCMs = pcm.getSubPCMs();
                        if (childrenPCMs != null) {
                            for (int j = 0; j < childrenPCMs.length; ++j) {
                                Class subclass = extent.getPMapper().getMetaInfoManager().getClass(childrenPCMs[j].getClassName());
                                if (subclass == null) {
                                    throw new MedorException("Impossible to retrieve the jorm class " + childrenPCMs[j].getClassName());
                                }
                                ClassMapping subCM = subclass.getClassMapping(extent.getProjectName(), JormRule.getMapperName(extent.getPMapper().getMapperName()));
                                if (subCM == null || (res = subCM.getPrimitiveElementMapping(jormFieldName)) == null) continue;
                                return res;
                            }
                        }
                    }
                    catch (PException e) {
                        throw new MedorException("Problem occurred while computing list of pems for sub classes.", e);
                    }
                }
            }
            if (res == null) {
                String msg = "No mapping for field '" + this.getJORMFieldName(fieldName, extent) + "' of the class '" + clazz.getFQName() + "' in the project '" + pn + "' and the mapping '" + mn;
                this.log.log(BasicLevel.ERROR, (Object)msg);
                this.log.log(BasicLevel.ERROR, (Object)"Existing field mappings:");
                Iterator it = cm.getAllPrimitiveElementMappings().iterator();
                while (it.hasNext()) {
                    res = (PrimitiveElementMapping)it.next();
                    this.log.log(BasicLevel.ERROR, (Object)("Field: " + ((PrimitiveElement)res.getLinkedMO()).getName()));
                }
                throw new MedorException(msg);
            }
            return res;
        }
        if (extent instanceof GenClassExtent) {
            GenClassRef gcr = (GenClassRef)extent.getMetaObject();
            GenClassMapping gcm = this.getGenClassMapping(extent);
            res = gcm.getPrimitiveElementMapping(this.getJORMFieldName(fieldName, extent));
            if (res == null) {
                String msg = "No mapping for field '" + this.getJORMFieldName(fieldName, extent) + "' of the generic class '" + gcr.getGenClassId() + "' in the project '" + pn + " and the mapping '" + mn;
                this.log.log(BasicLevel.ERROR, (Object)msg);
                this.log.log(BasicLevel.ERROR, (Object)"Existing field mappings:");
                Iterator it = gcm.getPrimitiveElementMappings().iterator();
                while (it.hasNext()) {
                    res = (PrimitiveElementMapping)it.next();
                    this.log.log(BasicLevel.ERROR, (Object)("Field: " + ((PrimitiveElement)res.getLinkedMO()).getName()));
                }
                throw new MedorException(msg);
            }
            return res;
        }
        throw new MedorException("Unmanaged JormExtent: " + extent);
    }

    protected String getJORMFieldName(String fullName, JormExtent ext) {
        int idx = fullName.indexOf(ext.getName() + '.');
        if (idx == -1) {
            return fullName;
        }
        return fullName.substring(ext.getName().length() + 1);
    }

    protected ClassMapping getClassMapping(JormExtent extent) throws MedorException {
        Mapping m;
        String pn = extent.getProjectName();
        PMapper mapper = extent.getPMapper();
        if (mapper == null) {
            String msg = "No mapper has not been assigned to the JormExtent (jorm name: " + extent.getJormName() + ", node name: " + extent.getName() + ")";
            this.log.log(BasicLevel.ERROR, (Object)msg);
            throw new MedorException(msg);
        }
        String mn = mapper.getMapperName();
        Class clazz = (Class)extent.getMetaObject();
        ClassProject cp = clazz.getClassProject(pn);
        if (cp == null) {
            String msg = "No project " + pn + " for the class " + clazz.getFQName();
            this.log.log(BasicLevel.ERROR, (Object)msg);
            throw new MedorException(msg);
        }
        int idx = mn.indexOf(46);
        if (idx != -1) {
            mn = mn.substring(0, idx);
        }
        if ((m = cp.getMapping(mn)) == null) {
            String msg = "No mapping '" + mn + "' in the project '" + pn + "' of the class " + clazz.getFQName();
            this.log.log(BasicLevel.ERROR, (Object)msg);
            throw new MedorException(msg);
        }
        return m.getClassMapping();
    }

    protected GenClassMapping getGenClassMapping(JormExtent extent) throws MedorException {
        Mapping m;
        String pn = extent.getProjectName();
        String mn = extent.getPMapper().getMapperName();
        GenClassRef gcr = (GenClassRef)extent.getMetaObject();
        MetaObject parentclazz = gcr.getParent();
        while (!(parentclazz instanceof Class)) {
            parentclazz = parentclazz.getParent();
        }
        ClassProject cp = ((Class)parentclazz).getClassProject(pn);
        if (cp == null) {
            String msg = "No project " + pn + " for the generic class " + gcr.getGenClassId();
            this.log.log(BasicLevel.ERROR, (Object)msg);
            throw new MedorException(msg);
        }
        int idx = mn.indexOf(46);
        if (idx != -1) {
            mn = mn.substring(0, idx);
        }
        if ((m = cp.getMapping(mn)) == null) {
            String msg = "No mapping '" + mn + "' in the project '" + pn + "' of the generic class " + gcr.getGenClassId();
            this.log.log(BasicLevel.ERROR, (Object)msg);
            throw new MedorException(msg);
        }
        return m.getGenClassMapping(gcr.getGenClassId());
    }

    protected Operand getPNCOperand(JormExtent extent, PNameField pnf) {
        PNameCoder pnc = JormPathHelper.getPNameCoder(pnf.getPNamingContextParameter(), extent.getPMapper());
        this.log.log(BasicLevel.DEBUG, (Object)("getPNCOperand for pnf " + pnf));
        if (pnc == null) {
            return new BasicParameterOperand(PTypeSpaceMedor.NAMING_CONTEXT, pnf.getPNamingContextParameter());
        }
        return new BasicOperand(pnc, PTypeSpaceMedor.NAMING_CONTEXT);
    }

    private static String getMapperName(String mn) {
        if (mn == null) {
            return null;
        }
        int idx = mn.indexOf(46);
        if (idx == -1) {
            return mn;
        }
        return mn.substring(0, idx);
    }
}

