/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.lib;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.PropagFromNestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.util.monolog.api.BasicLevel;

public class DropUselessNodeRule
extends BasicRule {
    public DropUselessNodeRule() {
        super("DropUselessNodeRule");
    }

    public QueryTree rewrite(QueryTree qt, QueryNode _parent) throws MedorException {
        this.debug = this.log != null && this.log.isLoggable(BasicLevel.DEBUG);
        UsedFields uf = this.isUseless(qt);
        return uf.isUseLess ? ((QueryTreeField)uf.fields[0]).getQueryTree() : qt;
    }

    protected UsedFields isUseless(QueryTree qt) throws MedorException {
        int i;
        UsedFields uf = new UsedFields();
        uf.fields = qt.getTupleStructure().getFields();
        uf.isUseLess = false;
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Fields: " + this.printFields(uf.fields)));
        }
        if (qt instanceof QueryLeaf) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)"useful");
            }
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("return " + this.printFields(uf.fields)));
            }
            return uf;
        }
        QueryNode qn = (QueryNode)qt;
        QueryTree[] children = qn.getChildren();
        uf.isUseLess = children.length == 1 && (!(qn instanceof FilteredQueryTree) || qn.getQueryFilter() == null);
        for (i = 0; i < uf.fields.length && uf.fields[i] instanceof PropagatedField && !(uf.fields[i] instanceof PropagFromNestedField) && ((PropagatedField)uf.fields[i]).getPreviousFields().length == 1; ++i) {
        }
        uf.isUseLess = uf.isUseLess & i == uf.fields.length;
        if (uf.isUseLess) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)"useless");
            }
            UsedFields child = this.isUseless(children[0]);
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("child: isUseLess:" + child.isUseLess + " ndfield: " + child.fields.length));
            }
            Field[] fields = new Field[uf.fields.length];
            for (i = 0; i < uf.fields.length; ++i) {
                QueryTreeField qtf = (QueryTreeField)((PropagatedField)uf.fields[i]).getPreviousFields()[0];
                int idx = qtf.getQueryTree().getTupleStructure().getFieldRank(qtf);
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("idx=" + idx));
                }
                fields[i] = child.fields[idx - 1];
            }
            uf.fields = fields;
        } else {
            Expression e;
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)"useful");
            }
            HashMap<QueryTree, UsedFields> childrenUseLess = new HashMap<QueryTree, UsedFields>();
            for (i = 0; i < children.length; ++i) {
                childrenUseLess.put(children[i], this.isUseless(children[i]));
            }
            for (i = 0; i < uf.fields.length; ++i) {
                if (this.debug) {
                    this.log.log(BasicLevel.DEBUG, (Object)("useful: field " + uf.fields[i].getName()));
                }
                if (uf.fields[i] instanceof PropagatedField) {
                    PropagatedField pf = (PropagatedField)uf.fields[i];
                    Field[] ancs = pf.getPreviousFields();
                    Field[] neoAncs = new QueryTreeField[ancs.length];
                    boolean mustReplace = false;
                    for (int j = 0; j < ancs.length; ++j) {
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)("useful: field " + uf.fields[i].getName() + " / ancestor: " + ancs[j].getName()));
                        }
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)("-> for QueryTree " + qt));
                        }
                        QueryTree qtof = ((QueryTreeField)ancs[j]).getQueryTree();
                        UsedFields childUF = (UsedFields)childrenUseLess.get(qtof);
                        if (this.debug) {
                            this.log.log(BasicLevel.DEBUG, (Object)("childUF.fields " + childUF.fields.length));
                        }
                        if (childUF != null) {
                            int idx = qtof.getTupleStructure().getFieldRank(ancs[j]);
                            mustReplace = true;
                            neoAncs[j] = (QueryTreeField)childUF.fields[idx - 1];
                            continue;
                        }
                        neoAncs[j] = (QueryTreeField)ancs[j];
                    }
                    if (!mustReplace) continue;
                    if (this.debug) {
                        this.log.log(BasicLevel.DEBUG, (Object)("replace " + this.printFields(pf.getPreviousFields()) + " by " + this.printFields(neoAncs)));
                    }
                    qn.updatePropagatedField(pf.getName(), (QueryTreeField[])neoAncs);
                    continue;
                }
                if (!(uf.fields[i] instanceof CalculatedField) || !this.replaceInFilter(e = ((CalculatedField)uf.fields[i]).getExpression(), childrenUseLess)) continue;
                qn.updateCalculatedField(uf.fields[i].getName(), e);
            }
            if (qn instanceof FilteredQueryTree && this.replaceInFilter(e = qn.getQueryFilter(), childrenUseLess)) {
                qn.setQueryFilter(e);
            }
        }
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("return " + this.printFields(uf.fields)));
        }
        return uf;
    }

    protected boolean replaceInFilter(Expression e, Map map) throws MedorException {
        QueryTreeField qtf;
        Field neo;
        if (e instanceof Operator) {
            boolean result = false;
            for (int i = 0; i < ((Operator)e).getOperandNumber(); ++i) {
                result |= this.replaceInFilter(((Operator)e).getExpression(i), map);
            }
            return result;
        }
        if (e instanceof FieldOperand && (neo = this.replaceField(qtf = (QueryTreeField)((FieldOperand)e).getField(), map)) != qtf) {
            ((FieldOperand)e).setField(neo);
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("Replace in FieldOperand " + qtf.getName() + " by " + neo.getName()));
            }
            return true;
        }
        return false;
    }

    protected Field replaceField(QueryTreeField qtf, Map map) throws MedorException {
        QueryTree qtChild = qtf.getQueryTree();
        UsedFields childUF = (UsedFields)map.get(qtChild);
        if (childUF != null) {
            int idx = qtChild.getTupleStructure().getFieldRank(qtf);
            return childUF.fields[idx - 1];
        }
        return qtf;
    }

    private String printFields(Field[] fs) {
        String m = "";
        for (int i = 0; i < fs.length; ++i) {
            m = m + (i == 0 ? "" : ",") + fs[i].getName();
        }
        return m;
    }

    public class UsedFields {
        public boolean isUseLess;
        public Field[] fields;
    }
}

