/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.writer;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.ws.ews.context.webservices.client.ServiceReferenceContext;
import org.apache.ws.ews.context.webservices.server.WSCFHandler;
import org.apache.ws.ews.context.webservices.server.WSCFInitParam;
import org.apache.ws.ews.context.webservices.server.WSCFSOAPHeader;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.writer.JOnASDeployWriter;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.wscf.JOnASWSCFHandler;

public class J2EEClientDeployWriter
extends JOnASDeployWriter {
    private static final String WSDD_PREFIX = "deploy-client-";

    public J2EEClientDeployWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, definition, symbolTable);
    }

    public void generate() throws IOException {
        if (!this.emitter.isServerSide()) {
            super.generate();
        }
    }

    protected void writeDeployServices(PrintWriter pw) throws IOException {
        int sRefIndex = this.getJonasWSContext().getServiceReferenceContextCount();
        if (sRefIndex == 1) {
            ServiceReferenceContext ctx = this.getJonasWSContext().getServiceReferenceContext(0);
            QName desiredServiceQName = ctx.getServiceQName();
            Service myService = this.getDefinition().getService(desiredServiceQName);
            if (myService != null) {
                pw.println();
                pw.println("  <!-- " + Messages.getMessage((String)"wsdlService00", (String)myService.getQName().getLocalPart()) + " -->");
                pw.println();
                for (Port myPort : myService.getPorts().values()) {
                    BindingEntry bEntry = this.getSymbolTable().getBindingEntry(myPort.getBinding().getQName());
                    if (bEntry.getBindingType() != 0) continue;
                    this.writeDeployPort(pw, myPort, bEntry, ctx);
                }
            }
        }
    }

    protected void writeDeployPort(PrintWriter pw, Port port, BindingEntry bEntry, ServiceReferenceContext ctx) {
        String serviceName = port.getName();
        boolean hasLiteral = bEntry.hasLiteral();
        boolean hasMIME = Utils.hasMIME((BindingEntry)bEntry);
        Use use = Use.DEFAULT;
        String styleStr = "";
        for (Object obj : bEntry.getBinding().getExtensibilityElements()) {
            UnknownExtensibilityElement unkElement;
            QName name;
            if (obj instanceof SOAPBinding) {
                use = Use.ENCODED;
                continue;
            }
            if (!(obj instanceof UnknownExtensibilityElement) || !(name = (unkElement = (UnknownExtensibilityElement)obj).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !name.getLocalPart().equals("binding")) continue;
            use = Use.ENCODED;
        }
        if (this.getSymbolTable().isWrapped()) {
            styleStr = " style=\"" + Style.WRAPPED + "\"";
            use = Use.LITERAL;
        } else {
            styleStr = " style=\"" + bEntry.getBindingStyle().getName() + "\"";
            if (hasLiteral) {
                use = Use.LITERAL;
            }
        }
        String useStr = " use=\"" + use + "\"";
        pw.println("  <service name=\"" + serviceName + "\" " + styleStr + useStr + " provider=\"java:Noop\">");
        if (hasMIME) {
            pw.println("      <parameter name=\"sendMultiRefs\" value=\"false\"/>");
        }
        pw.println("      <parameter name=\"typeMappingVersion\" value=\"" + this.emitter.getTypeMappingVersion() + "\"/>");
        this.writeDeployTypes(pw, bEntry.getBinding(), hasLiteral, hasMIME, use);
        WSCFHandler[] handlers = ctx.getHandlers();
        if (handlers != null && handlers.length != 0) {
            pw.println("    <handlerInfoChain>");
            for (int i = 0; i < handlers.length; ++i) {
                this.writeHandlerForPort(pw, (JOnASWSCFHandler)handlers[i], port);
            }
            pw.println("    </handlerInfoChain>");
        }
        pw.println("  </service>");
    }

    private void writeHandlerForPort(PrintWriter pw, JOnASWSCFHandler handler, Port port) {
        List ports = handler.getPortNames();
        if (ports.isEmpty()) {
            this.writeHandler(pw, handler);
        } else if (ports.contains(port.getName())) {
            this.writeHandler(pw, handler);
        }
    }

    private void writeHandler(PrintWriter pw, JOnASWSCFHandler handler) {
        pw.println("      <handlerInfo classname=\"" + handler.getHandlerClass() + "\">");
        WSCFInitParam[] param = handler.getInitParam();
        for (int i = 0; i < param.length; ++i) {
            pw.println("        <parameter name=\"" + param[i].getParamName() + "\" value=\"" + param[i].getParamValue() + "\"/>");
        }
        WSCFSOAPHeader[] headers = handler.getSoapHeader();
        for (int i = 0; i < headers.length; ++i) {
            pw.println("        <header xmlns:ns=\"" + headers[i].getNamespaceURI() + "\" qname=\"ns:" + headers[i].getLocalpart() + "\"/>");
        }
        pw.println("      </handlerInfo>");
        String[] roles = handler.getSoapRole();
        for (int i = 0; i < roles.length; ++i) {
            pw.println("      <role soapActorName=\"" + roles[i] + "\"/>");
        }
    }

    protected String getPrefix() {
        return WSDD_PREFIX;
    }
}

