/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Serializable;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Parameter;

public class BooleanClause
implements Serializable {
    private Query query;
    private Occur occur;

    public BooleanClause(Query query, Occur occur) {
        this.query = query;
        this.occur = occur;
    }

    public Occur getOccur() {
        return this.occur;
    }

    public void setOccur(Occur occur) {
        this.occur = occur;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public boolean isProhibited() {
        return Occur.MUST_NOT.equals(this.occur);
    }

    public boolean isRequired() {
        return Occur.MUST.equals(this.occur);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanClause)) {
            return false;
        }
        BooleanClause other = (BooleanClause)o;
        return this.query.equals(other.query) && this.occur.equals(other.occur);
    }

    public int hashCode() {
        return this.query.hashCode() ^ (Occur.MUST.equals(this.occur) ? 1 : 0) ^ (Occur.MUST_NOT.equals(this.occur) ? 2 : 0);
    }

    public String toString() {
        return this.occur.toString() + this.query.toString();
    }

    public static final class Occur
    extends Parameter
    implements Serializable {
        public static final Occur MUST = new Occur("MUST");
        public static final Occur SHOULD = new Occur("SHOULD");
        public static final Occur MUST_NOT = new Occur("MUST_NOT");

        private Occur(String name) {
            super(name);
        }

        public String toString() {
            if (this == MUST) {
                return "+";
            }
            if (this == MUST_NOT) {
                return "-";
            }
            return "";
        }
    }
}

