/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.core.SolrCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnowballPorterFilterFactory
extends BaseTokenFilterFactory {
    private String language = "English";

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String cfgLanguage = args.get("language");
        if (cfgLanguage != null) {
            this.language = cfgLanguage;
        }
        SolrCore.log.fine("SnowballPorterFilterFactory: language=" + this.language);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new SnowballFilter(input, this.language);
    }
}

