/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.solr.util.ContentStream;

public abstract class ContentStreamBase
implements ContentStream {
    public static final String DEFAULT_CHARSET = "utf-8";
    protected String name;
    protected String sourceInfo;
    protected String contentType;
    protected Long size;

    public static String getCharsetFromContentType(String contentType) {
        int idx;
        if (contentType != null && (idx = contentType.toLowerCase().indexOf("charset=")) > 0) {
            return contentType.substring(idx + "charset=".length()).trim();
        }
        return null;
    }

    public Reader getReader() throws IOException {
        String charset = ContentStreamBase.getCharsetFromContentType(this.getContentType());
        return charset == null ? new InputStreamReader(this.getStream(), DEFAULT_CHARSET) : new InputStreamReader(this.getStream(), charset);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public String getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(String sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public static class StringStream
    extends ContentStreamBase {
        private final String str;

        public StringStream(String str) {
            this.str = str;
            this.contentType = null;
            this.name = null;
            this.size = new Long(str.length());
            this.sourceInfo = "string";
        }

        public InputStream getStream() throws IOException {
            return new ByteArrayInputStream(this.str.getBytes());
        }

        public Reader getReader() throws IOException {
            String charset = StringStream.getCharsetFromContentType(this.contentType);
            return charset == null ? new StringReader(this.str) : new InputStreamReader(this.getStream(), charset);
        }
    }

    public static class FileStream
    extends ContentStreamBase {
        private final File file;

        public FileStream(File f) throws IOException {
            this.file = f;
            this.contentType = null;
            this.name = this.file.getName();
            this.size = this.file.length();
            this.sourceInfo = this.file.toURI().toString();
        }

        public InputStream getStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public Reader getReader() throws IOException {
            String charset = FileStream.getCharsetFromContentType(this.contentType);
            return charset == null ? new FileReader(this.file) : new InputStreamReader(this.getStream(), charset);
        }
    }

    public static class URLStream
    extends ContentStreamBase {
        private final URL url;
        final URLConnection conn;

        public URLStream(URL url) throws IOException {
            this.url = url;
            this.conn = this.url.openConnection();
            this.contentType = this.conn.getContentType();
            this.name = url.toExternalForm();
            this.size = new Long(this.conn.getContentLength());
            this.sourceInfo = "url";
        }

        public InputStream getStream() throws IOException {
            return this.conn.getInputStream();
        }
    }
}

