/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.TypeFactory;

public class Map
extends IndexedCollection {
    public Map(PersistentClass owner) {
        super(owner);
    }

    public boolean isMap() {
        return true;
    }

    public CollectionType getDefaultCollectionType() {
        if (this.isSorted()) {
            return TypeFactory.sortedMap(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded(), this.getComparator());
        }
        if (this.hasOrder()) {
            return TypeFactory.orderedMap(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded());
        }
        return TypeFactory.map(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded());
    }

    public void createAllKeys() throws MappingException {
        super.createAllKeys();
        if (!this.isInverse()) {
            this.getIndex().createForeignKey();
        }
    }

    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

