/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.optimization;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class IncrementalOptimizerStrategy
implements OptimizerStrategy {
    private static final Logger log = LoggerFactory.make();
    private int operationMax = -1;
    private int transactionMax = -1;
    private long operations = 0L;
    private long transactions = 0L;
    private DirectoryProvider directoryProvider;

    public void initialize(DirectoryProvider directoryProvider, Properties indexProperties, SearchFactoryImplementor searchFactoryImplementor) {
        this.directoryProvider = directoryProvider;
        this.operationMax = ConfigurationParseHelper.getIntValue(indexProperties, "optimizer.operation_limit.max", -1);
        this.transactionMax = ConfigurationParseHelper.getIntValue(indexProperties, "optimizer.transaction_limit.max", -1);
    }

    public void optimizationForced() {
        this.operations = 0L;
        this.transactions = 0L;
    }

    public boolean needOptimization() {
        return this.operationMax != -1 && this.operations >= (long)this.operationMax || this.transactionMax != -1 && this.transactions >= (long)this.transactionMax;
    }

    public void addTransaction(long operations) {
        this.operations += operations;
        ++this.transactions;
    }

    public void optimize(Workspace workspace) {
        if (this.needOptimization()) {
            log.debug("Optimize {} after {} operations and {} transactions", new Object[]{this.directoryProvider.getDirectory(), this.operations, this.transactions});
            IndexWriter writer = workspace.getIndexWriter(false);
            try {
                writer.optimize();
            }
            catch (IOException e) {
                throw new SearchException("Unable to optimize directoryProvider: " + this.directoryProvider.getDirectory().toString(), e);
            }
            this.optimizationForced();
        }
    }
}

