/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.instrument.cglib;

import java.io.ByteArrayInputStream;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.bytecode.util.BasicClassFilter;
import org.hibernate.bytecode.util.ClassDescriptor;
import org.hibernate.repackage.cglib.asm.ClassReader;
import org.hibernate.repackage.cglib.core.ClassNameReader;
import org.hibernate.tool.instrument.BasicInstrumentationTask;

public class InstrumentTask
extends BasicInstrumentationTask {
    private static final BasicClassFilter CLASS_FILTER = new BasicClassFilter();
    private final BytecodeProviderImpl provider = new BytecodeProviderImpl();
    static /* synthetic */ Class class$org$hibernate$repackage$cglib$transform$impl$InterceptFieldEnabled;

    protected ClassDescriptor getClassDescriptor(byte[] byecode) throws Exception {
        return new CustomClassDescriptor(byecode);
    }

    protected ClassTransformer getClassTransformer(ClassDescriptor descriptor) {
        if (descriptor.isInstrumented()) {
            this.logger.verbose("class [" + descriptor.getName() + "] already instrumented");
            return null;
        }
        return this.provider.getTransformer(CLASS_FILTER, new BasicInstrumentationTask.CustomFieldFilter(descriptor));
    }

    private static class CustomClassDescriptor
    implements ClassDescriptor {
        private final byte[] bytecode;
        private final String name;
        private final boolean isInstrumented;

        public CustomClassDescriptor(byte[] bytecode) throws Exception {
            this.bytecode = bytecode;
            ClassReader reader = new ClassReader(new ByteArrayInputStream(bytecode));
            String[] names = ClassNameReader.getClassInfo(reader);
            this.name = names[0];
            boolean instrumented = false;
            for (int i = 1; i < names.length; ++i) {
                if (!(class$org$hibernate$repackage$cglib$transform$impl$InterceptFieldEnabled == null ? InstrumentTask.class$("org.hibernate.repackage.cglib.transform.impl.InterceptFieldEnabled") : class$org$hibernate$repackage$cglib$transform$impl$InterceptFieldEnabled).getName().equals(names[i])) continue;
                instrumented = true;
                break;
            }
            this.isInstrumented = instrumented;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInstrumented() {
            return this.isInstrumented;
        }

        public byte[] getBytes() {
            return this.bytecode;
        }
    }
}

