/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.util.ArrayList;

public abstract class AbstractLuhnValidator {
    abstract int multiplicator();

    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String creditCard = (String)value;
        char[] chars = creditCard.toCharArray();
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (char c : chars) {
            if (!Character.isDigit(c)) continue;
            ints.add(c - 48);
        }
        int length = ints.size();
        int sum = 0;
        boolean even = false;
        for (int index = length - 1; index >= 0; --index) {
            int digit = (Integer)ints.get(index);
            if (even) {
                digit *= this.multiplicator();
            }
            if (digit > 9) {
                digit = digit / 10 + digit % 10;
            }
            sum += digit;
            even = !even;
        }
        return sum % 10 == 0;
    }
}

