/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.info.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.ow2.easybeans.api.bean.info.IMethodSecurityInfo;
import org.ow2.easybeans.api.bean.info.ISecurityInfo;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.EasyBeansDD;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.RunAs;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.SecurityRoleMapping;
import org.ow2.easybeans.deployment.metadata.ejbjar.xml.Session;
import org.ow2.easybeans.security.struct.JGroup;
import org.ow2.easybeans.security.struct.JPrincipal;
import org.ow2.util.ee.metadata.common.api.xml.struct.ISecurityRoleRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityInfo
implements ISecurityInfo {
    private List<String> declaredRoles = null;
    private List<IMethodSecurityInfo> methodSecurityInfos = null;
    private String runAsRole = null;
    private Subject runAsSubject = null;
    private EasyBeansEjbJarClassMetadata bean = null;

    public SecurityInfo(EasyBeansEjbJarClassMetadata bean) {
        this.bean = bean;
        this.methodSecurityInfos = new ArrayList<IMethodSecurityInfo>();
    }

    public void addMethodSecurityInfo(IMethodSecurityInfo methodSecurityInfo) {
        this.methodSecurityInfos.add(methodSecurityInfo);
    }

    public List<IMethodSecurityInfo> getMethodSecurityInfos() {
        return this.methodSecurityInfos;
    }

    public void setRunAsRole(String runAsRole) {
        this.runAsRole = runAsRole;
        this.runAsSubject = new Subject();
        Map<Principal, List<Principal>> principals = this.getRunAsPrincipals();
        Principal principal = principals.keySet().iterator().next();
        this.runAsSubject.getPrincipals().add(principal);
        JGroup roles = new JGroup("roles");
        roles.addMember(new JPrincipal(runAsRole));
        for (Principal member : principals.get(principal)) {
            roles.addMember(member);
        }
        this.runAsSubject.getPrincipals().add((Principal)((Object)roles));
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    public Subject getRunAsSubject() {
        return this.runAsSubject;
    }

    public void addDeclaredRole(String roleName) {
        this.declaredRoles.add(roleName);
    }

    public List<String> getDeclaredRoles() {
        return this.declaredRoles;
    }

    public void setDeclaredRole(List<String> declaredRoles) {
        this.declaredRoles = declaredRoles;
    }

    private Map<Principal, List<Principal>> getRunAsPrincipals() {
        HashMap<Principal, List<Principal>> principalMap = new HashMap<Principal, List<Principal>>();
        ArrayList<JPrincipal> principals = new ArrayList<JPrincipal>();
        JPrincipal principal = new JPrincipal(this.runAsRole);
        EasyBeansDD easyBeansDD = ((EjbJarArchiveMetadata)this.bean.getEjbJarDeployableMetadata()).getEasyBeansDD();
        if (easyBeansDD != null) {
            String beanName = this.bean.getJCommonBean().getName();
            List<Session> sessions = easyBeansDD.getEJB().getSessions();
            for (Session session : sessions) {
                RunAs runAs;
                String ejbName = session.getEjbName();
                if (!beanName.equals(ejbName) || (runAs = session.getRunAs()) == null) continue;
                String beanPincipalName = runAs.getPrincipalName();
                principal = new JPrincipal(beanPincipalName);
                for (SecurityRoleMapping securityRoleMapping : easyBeansDD.getSecurityRoleMappings()) {
                    for (String pincipalName : securityRoleMapping.getPrincipalNames()) {
                        if (!beanPincipalName.equals(pincipalName)) continue;
                        principals.add(new JPrincipal(securityRoleMapping.getRoleName()));
                    }
                }
            }
        }
        principalMap.put(principal, principals);
        return principalMap;
    }

    public List<ISecurityRoleRef> getSecurityRoleRefList() {
        return this.bean.getSecurityRoleRefList();
    }
}

