/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.asm.ClassWriter;
import org.ow2.easybeans.asm.Label;
import org.ow2.easybeans.asm.MethodVisitor;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.enhancer.CommonClassGenerator;
import org.ow2.easybeans.enhancer.interceptors.MethodInterceptorsBuilder;
import org.ow2.easybeans.enhancer.lib.MethodRenamer;
import org.ow2.util.ee.metadata.ejbjar.api.IJClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.InterceptorType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansInvocationContextGenerator
extends CommonClassGenerator {
    public static final String PACKAGE_NAME_PREFIX = "org.ow2.easybeans.gen.invocationcontext.";
    public static final String ARG = "arg";
    public static final String INTERCEPTOR = "interceptor";
    public static final String SUFFIX_CLASS = "EasyBeansInvocationContextImpl";
    public static final String[] INTERFACES = new String[]{"org/ow2/easybeans/api/EasyBeansInvocationContext"};
    public static final String[] PROCEED_EXCEPTIONS = new String[]{Type.getInternalName(Exception.class)};
    public static final String EASYBEANS_INVOCATION_CONTEXT = Type.getDescriptor(EasyBeansInvocationContext.class);
    private static Log logger = LogFactory.getLog(EasyBeansInvocationContextGenerator.class);
    private EasyBeansEjbJarClassMetadata classAnnotationMetadata = null;
    private String packageName = null;
    private String generatedClassName = null;
    private JMethod jMethod = null;
    private EasyBeansEjbJarMethodMetadata methodAnnotationMetadata;
    private String beanClassDesc = null;
    private String beanClassName = null;
    private Type beanClassType = null;
    private String constructorDesc = null;
    private Type[] methodArgsType = null;
    private List<IJClassInterceptor> allInterceptors = null;
    private InterceptorType interceptorType = null;
    private String interceptorManagerClassName = null;
    public static final String SUFFIX_INTERCEPTOR_MANAGER = "InterceptorManager";

    public EasyBeansInvocationContextGenerator(EasyBeansEjbJarMethodMetadata methodAnnotationMetadata, InterceptorType interceptorType) {
        super(new ClassWriter(1));
        this.methodAnnotationMetadata = methodAnnotationMetadata;
        this.classAnnotationMetadata = (EasyBeansEjbJarClassMetadata)methodAnnotationMetadata.getClassMetadata();
        this.jMethod = methodAnnotationMetadata.getJMethod();
        this.packageName = PACKAGE_NAME_PREFIX + this.classAnnotationMetadata.getClassName();
        this.interceptorType = interceptorType;
        this.interceptorManagerClassName = this.classAnnotationMetadata.getClassName() + SUFFIX_INTERCEPTOR_MANAGER;
        this.generatedClassName = this.packageName.replace(".", "/") + "/" + SUFFIX_CLASS;
        this.generatedClassName = this.generatedClassName + methodAnnotationMetadata.getJMethod().getName() + interceptorType.name().replace("_", "");
        this.generatedClassName = this.generatedClassName + Math.abs(methodAnnotationMetadata.getJMethod().getDescriptor().hashCode());
        this.beanClassDesc = EasyBeansInvocationContextGenerator.encodeClassDesc(this.classAnnotationMetadata.getClassName());
        this.beanClassName = this.classAnnotationMetadata.getClassName();
        this.beanClassType = Type.getType(this.beanClassDesc);
        this.methodArgsType = Type.getArgumentTypes(this.jMethod.getDescriptor());
        this.allInterceptors = new MethodInterceptorsBuilder(methodAnnotationMetadata, interceptorType).getAllInterceptors();
    }

    public void generate() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating InvocationContext for Method " + this.jMethod + " of class " + this.beanClassName), new Object[0]);
        }
        this.addClassDeclaration();
        this.addAttributes();
        this.addConstructor();
        this.addStaticClassInitialization();
        this.addMethods();
        this.endClass();
        if (logger.isDebugEnabled()) {
            String fName = System.getProperty("java.io.tmpdir") + File.separator + this.generatedClassName.replace("/", ".") + ".class";
            logger.debug((Object)("Writing Invocation context of method " + this.methodAnnotationMetadata.getMethodName() + " to " + fName), new Object[0]);
            try {
                FileOutputStream fos = new FileOutputStream(fName);
                fos.write(this.getCW().toByteArray());
                fos.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public byte[] getBytes() {
        return this.getCW().toByteArray();
    }

    private void addClassDeclaration() {
        this.getCW().visit(49, 33, this.generatedClassName, null, "java/lang/Object", INTERFACES);
    }

    private void addConstructor() {
        String argsMethodDesc = "";
        for (Type t : this.methodArgsType) {
            argsMethodDesc = argsMethodDesc + t.getDescriptor();
        }
        this.constructorDesc = "(" + this.beanClassDesc + argsMethodDesc + ")V";
        MethodVisitor mv = this.getCW().visitMethod(1, "<init>", this.constructorDesc, null, null);
        mv.visitCode();
        int arg = 1;
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        int argBean = arg++;
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, argBean);
        mv.visitFieldInsn(181, this.generatedClassName, "bean", EasyBeansInvocationContextGenerator.encodeClassDesc(this.classAnnotationMetadata.getClassName()));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, argBean);
        mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansFactory", "()Lorg/ow2/easybeans/api/Factory;");
        mv.visitFieldInsn(181, this.generatedClassName, "factory", "Lorg/ow2/easybeans/api/Factory;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, argBean);
        mv.visitMethodInsn(182, this.classAnnotationMetadata.getClassName(), "getEasyBeansInterceptorManager", "()" + EasyBeansInvocationContextGenerator.encodeClassDesc(this.interceptorManagerClassName));
        mv.visitFieldInsn(181, this.generatedClassName, "interceptorManager", EasyBeansInvocationContextGenerator.encodeClassDesc(this.interceptorManagerClassName));
        int methodArg = 0;
        for (Type type : this.methodArgsType) {
            mv.visitVarInsn(25, 0);
            int opCode = EasyBeansInvocationContextGenerator.putFieldLoadOpCode(type.getSort());
            mv.visitVarInsn(opCode, arg++);
            mv.visitFieldInsn(181, this.generatedClassName, ARG + methodArg++, type.getDescriptor());
            if (opCode != 22 && opCode != 24) continue;
            ++arg;
        }
        int index = 0;
        for (IJClassInterceptor interceptor : this.allInterceptors) {
            if (interceptor.getClassName().equals(this.beanClassName)) continue;
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedClassName, "interceptorManager", EasyBeansInvocationContextGenerator.encodeClassDesc(this.interceptorManagerClassName));
            String getterName = "get" + interceptor.getClassName().replace("/", "");
            mv.visitMethodInsn(182, this.interceptorManagerClassName, getterName, "()" + EasyBeansInvocationContextGenerator.encodeClassDesc(interceptor.getClassName()));
            mv.visitFieldInsn(181, this.generatedClassName, INTERCEPTOR + index++, EasyBeansInvocationContextGenerator.encodeClassDesc(interceptor.getClassName()));
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void endClass() {
        this.getCW().visitEnd();
    }

    private void addAttributes() {
        this.addInvocationContextAttributes();
        this.addEasyBeansInvocationContextAttributes();
    }

    private void addMethods() {
        this.addInvocationContextMethods();
        this.addEasyBeansInvocationContextMethods();
        this.addToString();
    }

    private void addInvocationContextMethods() {
        this.addInvocationContextGetParameters();
        this.addInvocationContextSetParameters();
        this.addInvocationContextGetMethod();
        this.addInvocationContextGetTarget();
        this.addInvocationContextProceed();
        this.addInvocationContextGetContextData();
    }

    private void addEasyBeansInvocationContextMethods() {
        this.addEasyBeansInvocationContextGetFactory();
    }

    private void addInvocationContextGetTarget() {
        MethodVisitor mv = this.getCW().visitMethod(1, "getTarget", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedClassName, "bean", this.beanClassDesc);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addEasyBeansInvocationContextGetFactory() {
        MethodVisitor mv = this.getCW().visitMethod(1, "getFactory", "()" + EASYBEANS_FACTORY, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedClassName, "factory", EASYBEANS_FACTORY);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addInvocationContextGetMethod() {
        MethodVisitor mv = this.getCW().visitMethod(1, "getMethod", "()Ljava/lang/reflect/Method;", null, null);
        mv.visitCode();
        if (this.interceptorType == InterceptorType.AROUND_INVOKE) {
            mv.visitFieldInsn(178, this.generatedClassName, "method", "Ljava/lang/reflect/Method;");
            Label notNullParametersLabel = new Label();
            mv.visitJumpInsn(199, notNullParametersLabel);
            Label tryLabel = new Label();
            mv.visitLabel(tryLabel);
            mv.visitLdcInsn(this.beanClassType);
            mv.visitLdcInsn(this.jMethod.getName());
            mv.visitIntInsn(16, this.methodArgsType.length);
            mv.visitTypeInsn(189, "java/lang/Class");
            int argCount = 0;
            for (Type type : this.methodArgsType) {
                mv.visitInsn(89);
                mv.visitIntInsn(16, argCount);
                EasyBeansInvocationContextGenerator.visitClassType(type, mv);
                mv.visitInsn(83);
                ++argCount;
            }
            mv.visitMethodInsn(182, "java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
            mv.visitFieldInsn(179, this.generatedClassName, "method", "Ljava/lang/reflect/Method;");
            mv.visitJumpInsn(167, notNullParametersLabel);
            Label firstCatchLabel = new Label();
            mv.visitLabel(firstCatchLabel);
            mv.visitVarInsn(58, 1);
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn("Cannot find method due to a security exception");
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V");
            mv.visitInsn(191);
            Label secondCatchLabel = new Label();
            mv.visitLabel(secondCatchLabel);
            mv.visitVarInsn(58, 1);
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn("Cannot find the method");
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V");
            mv.visitInsn(191);
            mv.visitLabel(notNullParametersLabel);
            mv.visitFieldInsn(178, this.generatedClassName, "method", "Ljava/lang/reflect/Method;");
            mv.visitInsn(176);
            mv.visitTryCatchBlock(tryLabel, firstCatchLabel, firstCatchLabel, "java/lang/SecurityException");
            mv.visitTryCatchBlock(tryLabel, firstCatchLabel, secondCatchLabel, "java/lang/NoSuchMethodException");
        } else {
            mv.visitInsn(1);
            mv.visitInsn(176);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addInvocationContextAttributes() {
        this.addAttribute(2, "bean", this.beanClassDesc);
        this.addAttribute(2, "parameters", "[Ljava/lang/Object;");
        this.addAttribute(10, "method", "Ljava/lang/reflect/Method;");
        this.addAttribute(2, INTERCEPTOR, "I", 0);
        int arg = 0;
        for (Type t : this.methodArgsType) {
            this.addAttribute(2, ARG + arg++, t.getDescriptor());
        }
        int intercpt = 0;
        for (IJClassInterceptor interceptor : this.allInterceptors) {
            if (interceptor.getClassName().equals(this.beanClassName)) continue;
            this.addAttribute(2, INTERCEPTOR + intercpt++, EasyBeansInvocationContextGenerator.encodeClassDesc(interceptor.getClassName()));
        }
        this.addAttribute(2, "contextData", "Ljava/util/Map;");
    }

    private void addStaticClassInitialization() {
        MethodVisitor mv = this.getCW().visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitInsn(1);
        mv.visitFieldInsn(179, this.generatedClassName, "method", "Ljava/lang/reflect/Method;");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addEasyBeansInvocationContextAttributes() {
        this.addAttribute(2, "factory", EASYBEANS_FACTORY);
        this.addAttribute(2, "interceptorManager", EasyBeansInvocationContextGenerator.encodeClassDesc(this.interceptorManagerClassName));
    }

    private void addInvocationContextProceed() {
        MethodVisitor mv = this.getCW().visitMethod(1, "proceed", "()Ljava/lang/Object;", null, PROCEED_EXCEPTIONS);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, this.generatedClassName, INTERCEPTOR, "I");
        mv.visitInsn(4);
        mv.visitInsn(96);
        mv.visitFieldInsn(181, this.generatedClassName, INTERCEPTOR, "I");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedClassName, INTERCEPTOR, "I");
        int sizeInterceptors = this.allInterceptors.size();
        int switchSize = sizeInterceptors + 1;
        Label[] switchLabels = new Label[switchSize];
        for (int s = 0; s < switchSize; ++s) {
            switchLabels[s] = new Label();
        }
        Label defaultCaseLabel = new Label();
        mv.visitTableSwitchInsn(1, switchSize, defaultCaseLabel, switchLabels);
        int index = 0;
        int interceptorIndex = 0;
        for (IJClassInterceptor interceptor : this.allInterceptors) {
            mv.visitLabel(switchLabels[index]);
            Type returnType = Type.getReturnType(interceptor.getJMethod().getDescriptor());
            if (interceptor.getClassName().equals(this.beanClassName)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.generatedClassName, "bean", this.beanClassDesc);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, this.beanClassName, interceptor.getJMethod().getName(), interceptor.getJMethod().getDescriptor());
                EasyBeansInvocationContextGenerator.returnsObject(returnType, mv);
            } else {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.generatedClassName, INTERCEPTOR + interceptorIndex, EasyBeansInvocationContextGenerator.encodeClassDesc(interceptor.getClassName()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, interceptor.getClassName(), interceptor.getJMethod().getName(), interceptor.getJMethod().getDescriptor());
                EasyBeansInvocationContextGenerator.returnsObject(returnType, mv);
                ++interceptorIndex;
            }
            ++index;
        }
        mv.visitLabel(switchLabels[index++]);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedClassName, "bean", this.beanClassDesc);
        int indexArg = 0;
        for (Type argType : this.methodArgsType) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedClassName, ARG + indexArg++, argType.getDescriptor());
        }
        String interceptedMethod = null;
        interceptedMethod = this.interceptorType.equals((Object)InterceptorType.AROUND_INVOKE) ? MethodRenamer.encode(this.jMethod.getName()) : this.jMethod.getName();
        mv.visitMethodInsn(182, this.beanClassName, interceptedMethod, this.jMethod.getDescriptor());
        Type returnType = Type.getReturnType(this.jMethod.getDescriptor());
        EasyBeansInvocationContextGenerator.returnsObject(returnType, mv);
        mv.visitLabel(defaultCaseLabel);
        mv.visitTypeInsn(187, "java/lang/IllegalStateException");
        mv.visitInsn(89);
        mv.visitLdcInsn("Problem in interceptors. Shouldn't go in the default case.");
        mv.visitMethodInsn(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void addInvocationContextGetContextData() {
        MethodVisitor mv = this.getCW().visitMethod(1, "getContextData", "()Ljava/util/Map;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedClassName, "contextData", "Ljava/util/Map;");
        Label elseLabel = new Label();
        mv.visitJumpInsn(199, elseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, "java/util/HashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        mv.visitFieldInsn(181, this.generatedClassName, "contextData", "Ljava/util/Map;");
        mv.visitLabel(elseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.generatedClassName, "contextData", "Ljava/util/Map;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addInvocationContextGetParameters() {
        MethodVisitor mv = this.getCW().visitMethod(1, "getParameters", "()[Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (this.interceptorType == InterceptorType.AROUND_INVOKE) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedClassName, "parameters", "[Ljava/lang/Object;");
            Label notNullParametersLabel = new Label();
            mv.visitJumpInsn(199, notNullParametersLabel);
            mv.visitVarInsn(25, 0);
            mv.visitIntInsn(16, this.methodArgsType.length);
            mv.visitTypeInsn(189, "java/lang/Object");
            int argCount = 0;
            for (Type type : this.methodArgsType) {
                mv.visitInsn(89);
                mv.visitIntInsn(16, argCount);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.generatedClassName, ARG + argCount, type.getDescriptor());
                EasyBeansInvocationContextGenerator.transformPrimitiveIntoObject(type, mv);
                mv.visitInsn(83);
                ++argCount;
            }
            mv.visitFieldInsn(181, this.generatedClassName, "parameters", "[Ljava/lang/Object;");
            mv.visitLabel(notNullParametersLabel);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedClassName, "parameters", "[Ljava/lang/Object;");
        } else {
            mv.visitTypeInsn(187, "java/lang/IllegalStateException");
            mv.visitInsn(89);
            mv.visitLdcInsn("Operation getParameters can only be applied on AroundInvoke interceptors");
            mv.visitMethodInsn(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addInvocationContextSetParameters() {
        MethodVisitor mv = this.getCW().visitMethod(1, "setParameters", "([Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        if (this.interceptorType == InterceptorType.AROUND_INVOKE) {
            mv.visitVarInsn(25, 1);
            Label notNull = new Label();
            mv.visitJumpInsn(199, notNull);
            mv.visitTypeInsn(187, "java/lang/IllegalStateException");
            mv.visitInsn(89);
            mv.visitLdcInsn("Cannot set a null array.");
            mv.visitMethodInsn(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
            mv.visitLabel(notNull);
            mv.visitVarInsn(25, 1);
            mv.visitInsn(190);
            mv.visitIntInsn(16, this.methodArgsType.length);
            Label sizeOk = new Label();
            mv.visitJumpInsn(159, sizeOk);
            mv.visitTypeInsn(187, "java/lang/IllegalStateException");
            mv.visitInsn(89);
            mv.visitLdcInsn("Invalid size of the given array. The length should be '" + this.methodArgsType.length + "'.");
            mv.visitMethodInsn(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
            mv.visitLabel(sizeOk);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, this.generatedClassName, "parameters", "[Ljava/lang/Object;");
            int argCount = 0;
            for (Type type : this.methodArgsType) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitIntInsn(16, argCount);
                mv.visitInsn(50);
                EasyBeansInvocationContextGenerator.transformObjectIntoPrimitive(type, mv);
                mv.visitFieldInsn(181, this.generatedClassName, ARG + argCount, type.getDescriptor());
                ++argCount;
            }
        } else {
            mv.visitTypeInsn(187, "java/lang/IllegalStateException");
            mv.visitInsn(89);
            mv.visitLdcInsn("Operation setParameters can only be applied on AroundInvoke interceptors");
            mv.visitMethodInsn(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addToString() {
        MethodVisitor mv = this.getCW().visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        int localVar = 1;
        int varSB = localVar++;
        int varCLASSNAMES = localVar++;
        int varCLASSNAME = localVar++;
        int varINDENT2 = localVar++;
        int varINDENT4 = localVar++;
        int varI = localVar++;
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        mv.visitVarInsn(58, varSB);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mv.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;");
        mv.visitLdcInsn("\\.");
        mv.visitMethodInsn(182, "java/lang/String", "split", "(Ljava/lang/String;)[Ljava/lang/String;");
        mv.visitVarInsn(58, varCLASSNAMES);
        mv.visitVarInsn(25, varCLASSNAMES);
        mv.visitVarInsn(25, varCLASSNAMES);
        mv.visitInsn(190);
        mv.visitInsn(4);
        mv.visitInsn(100);
        mv.visitInsn(50);
        mv.visitVarInsn(58, varCLASSNAME);
        mv.visitVarInsn(25, varSB);
        mv.visitVarInsn(25, varCLASSNAME);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitInsn(87);
        mv.visitVarInsn(25, varSB);
        mv.visitLdcInsn("[\n");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitInsn(87);
        mv.visitLdcInsn("  ");
        mv.visitVarInsn(58, varINDENT2);
        mv.visitLdcInsn("    ");
        mv.visitVarInsn(58, varINDENT4);
        mv.visitVarInsn(25, varSB);
        mv.visitVarInsn(25, varINDENT2);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitInsn(87);
        mv.visitVarInsn(25, varSB);
        mv.visitLdcInsn("List of interceptors :\n");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitInsn(87);
        int i = 1;
        mv.visitInsn(4);
        mv.visitVarInsn(54, varI);
        if (this.allInterceptors != null) {
            for (IJClassInterceptor interceptor : this.allInterceptors) {
                mv.visitVarInsn(25, varSB);
                mv.visitVarInsn(25, varINDENT4);
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                mv.visitInsn(87);
                mv.visitVarInsn(25, varSB);
                mv.visitVarInsn(21, varI);
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
                mv.visitInsn(87);
                mv.visitVarInsn(25, varSB);
                mv.visitLdcInsn(") - ");
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                mv.visitInsn(87);
                mv.visitVarInsn(25, varSB);
                mv.visitLdcInsn(interceptor.getClassName());
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                mv.visitInsn(87);
                mv.visitVarInsn(25, varSB);
                mv.visitLdcInsn("[");
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                mv.visitInsn(87);
                mv.visitVarInsn(25, varSB);
                mv.visitLdcInsn(interceptor.getJMethod().getName());
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                mv.visitInsn(87);
                mv.visitVarInsn(25, varSB);
                mv.visitLdcInsn("]\n");
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                mv.visitInsn(87);
                ++i;
                mv.visitIincInsn(varI, 1);
            }
            mv.visitVarInsn(25, varSB);
            mv.visitVarInsn(25, varINDENT2);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitInsn(87);
            mv.visitVarInsn(25, varSB);
            mv.visitLdcInsn("Current interceptor : ");
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitInsn(87);
            mv.visitVarInsn(25, varSB);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.generatedClassName, INTERCEPTOR, "I");
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
            mv.visitInsn(87);
            mv.visitVarInsn(25, varSB);
            mv.visitLdcInsn("/");
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitInsn(87);
            mv.visitVarInsn(25, varSB);
            mv.visitLdcInsn(String.valueOf(this.allInterceptors.size()));
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitInsn(87);
        } else {
            mv.visitVarInsn(25, varSB);
            mv.visitVarInsn(25, varINDENT2);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitInsn(87);
            mv.visitVarInsn(25, varSB);
            mv.visitLdcInsn("No interceptors : ");
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, varSB);
        mv.visitLdcInsn("\n");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitInsn(87);
        mv.visitVarInsn(25, varSB);
        mv.visitLdcInsn("]");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitInsn(87);
        mv.visitVarInsn(25, varSB);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public EasyBeansEjbJarMethodMetadata getMethodAnnotationMetadata() {
        return this.methodAnnotationMetadata;
    }

    public String getGeneratedClassName() {
        return this.generatedClassName;
    }

    public String getConstructorDesc() {
        return this.constructorDesc;
    }

    public List<IJClassInterceptor> getAllInterceptors() {
        return this.allInterceptors;
    }
}

