/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.naming.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.Context;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.naming.NamingInterceptor;
import org.ow2.easybeans.naming.interceptors.AbsENCInterceptor;

public class JOnASENCInterceptor
extends AbsENCInterceptor
implements NamingInterceptor {
    protected static final String JONAS_NAMING_MANAGER_CLASS = "org.objectweb.jonas.naming.NamingManager";
    private Object jonasNamingManager = null;
    private Method setComponentContextMethod = null;
    private Method resetComponentContextMethod = null;

    public JOnASENCInterceptor() {
        if (this.jonasNamingManager == null) {
            Method getInstance;
            String errMsg = "Check that EasyBeans is embedded in JOnAS application server.";
            Class<?> namingClass = null;
            try {
                namingClass = Thread.currentThread().getContextClassLoader().loadClass(JONAS_NAMING_MANAGER_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load the JOnAS naming manager class 'org.objectweb.jonas.naming.NamingManager'. " + errMsg, e);
            }
            try {
                getInstance = namingClass.getMethod("getInstance", new Class[0]);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get a method on the JOnAS naming manager class 'org.objectweb.jonas.naming.NamingManager'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get a method on the JOnAS naming manager class 'org.objectweb.jonas.naming.NamingManager'. " + errMsg, e);
            }
            try {
                this.jonasNamingManager = getInstance.invoke(null, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Cannot get the the JOnAS naming manager instance'. " + errMsg, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot get the the JOnAS naming manager instance'. " + errMsg, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Cannot get the the JOnAS naming manager instance'. " + errMsg, e);
            }
            try {
                this.setComponentContextMethod = namingClass.getMethod("setComponentContext", Context.class);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get setComponentContext(Context) method on the JOnAS naming manager class 'org.objectweb.jonas.naming.NamingManager'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get setComponentContext(Context) method on the JOnAS naming manager class 'org.objectweb.jonas.naming.NamingManager'. " + errMsg, e);
            }
            try {
                this.resetComponentContextMethod = namingClass.getMethod("resetComponentContext", Context.class);
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Cannot get resetComponentContext(Context) method on the JOnAS naming manager class 'org.objectweb.jonas.naming.NamingManager'. " + errMsg, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Cannot get resetComponentContext(Context) method on the JOnAS naming manager class 'org.objectweb.jonas.naming.NamingManager'. " + errMsg, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(EasyBeansInvocationContext invocationContext) throws Exception {
        Object object;
        Context oldContext = (Context)this.setComponentContextMethod.invoke(this.jonasNamingManager, invocationContext.getFactory().getJavaContext());
        try {
            object = invocationContext.proceed();
        }
        catch (Throwable throwable) {
            this.resetComponentContextMethod.invoke(this.jonasNamingManager, oldContext);
            throw throwable;
        }
        this.resetComponentContextMethod.invoke(this.jonasNamingManager, oldContext);
        return object;
    }
}

