/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.util.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.ow2.easybeans.util.marshalling.CtxClassLoaderObjectInputStream;

public final class Serialization {
    private Serialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] storeObject(Serializable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadObject(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        CtxClassLoaderObjectInputStream ctxClassLoaderObjectInputStream = new CtxClassLoaderObjectInputStream(bais);
        try {
            Object object = ctxClassLoaderObjectInputStream.readObject();
            return object;
        }
        finally {
            if (ctxClassLoaderObjectInputStream != null) {
                ctxClassLoaderObjectInputStream.close();
            }
            if (ctxClassLoaderObjectInputStream != null) {
                bais.close();
            }
        }
    }
}

