/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.log;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JDKConsoleHandler
extends Handler {
    private Writer infoOutputWriter = new OutputStreamWriter(System.out);
    private Writer errOutputWriter = new OutputStreamWriter(System.err);

    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        String msg = null;
        try {
            msg = this.getFormatter().format(logRecord);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        Writer writer = null;
        writer = logRecord.getLevel().intValue() >= Level.WARNING.intValue() ? this.errOutputWriter : this.infoOutputWriter;
        try {
            writer.write(msg);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
        this.flush(writer);
    }

    private void flush(Writer writer) {
        try {
            writer.flush();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 2);
        }
    }

    public void flush() {
        this.flush(this.errOutputWriter);
        this.flush(this.infoOutputWriter);
    }

    public void close() {
        this.flush();
    }
}

