/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl;

import java.io.File;
import java.util.Dictionary;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactoryManager;
import org.ow2.util.plan.fetcher.impl.FetcherActivator;

public class LocalRepositoriesBaseDirConfiguration
implements ManagedService {
    private Log logger = LogFactory.getLog(FetcherActivator.class);
    private File localRepositoriesBaseDir = null;
    private IResourceFetcherFactoryManager resourceFetcherFactoryManager;

    public LocalRepositoriesBaseDirConfiguration(IResourceFetcherFactoryManager manager) {
        this.resourceFetcherFactoryManager = manager;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties != null) {
            String path = (String)properties.get("local.repositories.base.dir");
            this.logger.debug((Object)"Local repositories base directory property updated: '{0}", new Object[]{path});
            if (path == null) {
                throw new ConfigurationException("local.repositories.base.dir", "Path to the local repositories is null.");
            }
            File localDir = new File(path);
            if (!localDir.exists()) {
                localDir.mkdirs();
            }
            this.localRepositoriesBaseDir = localDir;
            for (IResourceFetcherFactory factory : this.resourceFetcherFactoryManager) {
                factory.setLocalRepositoriesBaseDir(this.localRepositoriesBaseDir);
            }
        }
    }
}

