/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.client;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.persistence.EntityManagerFactory;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.cmi.ha.interceptor.iiop.HAInterceptorInitializer;
import org.ow2.easybeans.injection.api.ArchiveInjectionException;
import org.ow2.easybeans.injection.impl.ArchiveInjection;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.persistence.PersistenceUnitManager;
import org.ow2.easybeans.persistence.api.PersistenceXmlFileAnalyzerException;
import org.ow2.easybeans.persistence.xml.PersistenceXmlFileAnalyzer;
import org.ow2.easybeans.server.Embedded;
import org.ow2.jonas.Version;
import org.ow2.jonas.client.ClientContainerException;
import org.ow2.jonas.client.naming.ClientInitialContextFactory;
import org.ow2.jonas.deployment.api.IEnvEntryDesc;
import org.ow2.jonas.deployment.api.IResourceEnvRefDesc;
import org.ow2.jonas.deployment.api.IResourceRefDesc;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.client.ClientContainerDeploymentDesc;
import org.ow2.jonas.deployment.client.ClientContainerDeploymentDescException;
import org.ow2.jonas.deployment.client.lib.ClientDeploymentDescManager;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.PersistenceUnitRefDesc;
import org.ow2.jonas.deployment.ear.EarDeploymentDesc;
import org.ow2.jonas.deployment.ear.EarDeploymentDescException;
import org.ow2.jonas.deployment.ear.lib.EarDeploymentDescManager;
import org.ow2.jonas.deployment.ear.xml.Web;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.deployment.web.lib.WebDeploymentDescManager;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genclientstub.ClientStubGen;
import org.ow2.jonas.generators.wsgen.WsGen;
import org.ow2.jonas.lib.cpmanager.EarClassPathManager;
import org.ow2.jonas.lib.cpmanager.EarClassPathManagerException;
import org.ow2.jonas.lib.cpmanager.JarList;
import org.ow2.jonas.lib.cpmanager.JarListException;
import org.ow2.jonas.lib.naming.SingletonComponentContextFactory;
import org.ow2.jonas.lib.naming.SingletonNamingManager;
import org.ow2.jonas.lib.security.mapping.JPolicyUserRoleMapping;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.security.auth.callback.NoInputCallbackHandler;
import org.ow2.jonas.security.interceptors.iiop.SecurityInitializer;
import org.ow2.jonas.tm.jotm.ots.OTSORBInitializer;
import org.ow2.jonas.ws.jaxrpc.base.ClientJServiceFactoryFinder;
import org.ow2.jonas.ws.jaxrpc.factory.JServiceFactory;
import org.ow2.jonas.ws.jaxws.client.JAXWSWebServiceRefBuilder;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.LibDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.ee.metadata.car.api.ICarDeployableMetadata;
import org.ow2.util.ee.metadata.common.api.enc.IENCBinding;
import org.ow2.util.ee.metadata.common.api.enc.IENCBindingHolder;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientContainer {
    private static final String CAROL_FILE = "carol.properties";
    private String mainClass = null;
    private String tmpDir = null;
    private String jarClient = null;
    private String classpath = null;
    private String clientTraceFile = null;
    private File clientJarFile = null;
    private JNamingManager naming;
    private String carolFile = null;
    private String[] args = null;
    private URLClassLoader earClassLoader = null;
    private List<String> appArgs = null;
    private URL[] extensionsURLs = null;
    private Logger logger = null;
    private boolean applyWsGen = true;
    private boolean applyGenClientStub = false;
    private PersistenceUnitManager persistenceUnitManager = null;
    private static final String IIOP_INTERCEPTOR = "org.omg.PortableInterceptor.ORBInitializerClass.";

    private ClientContainer(String[] args) {
        this.args = args;
        this.appArgs = new ArrayList<String>();
    }

    private void initLogger() {
        Log.configure((String)this.clientTraceFile);
        this.logger = Log.getLogger((String)"org.ow2.jonas.client");
    }

    public static void main(String[] args) {
        ClientContainer cc = new ClientContainer(args);
        try {
            cc.start();
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String message = t.getMessage();
            if (t instanceof Error) {
                System.err.println("There was the following error : " + message);
            } else if (t instanceof Exception) {
                System.err.println("There was the following exception : " + message);
            }
            t.printStackTrace(System.err);
        }
        catch (Exception e) {
            System.err.println("There was the following exception : " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void start() throws Exception {
        String err;
        Attributes attributes;
        Manifest manifest;
        File argFile;
        this.analyzeArgs();
        if (this.clientTraceFile != null) {
            File tClient = new File(this.clientTraceFile);
            if (!tClient.exists()) {
                throw new ClientContainerException("The file '" + this.clientTraceFile + "' was not found.");
            }
            if (!tClient.isFile()) {
                throw new ClientContainerException("The file '" + this.clientTraceFile + "' is not a valid file. Maybe a directory ?");
            }
            System.setProperty("jonas.client.trace.file", this.clientTraceFile);
            Log.reset();
        } else {
            this.clientTraceFile = "traceclient";
        }
        this.initLogger();
        String userArg = null;
        String fileName = null;
        boolean fileMode = true;
        try {
            userArg = this.appArgs.get(0);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.usage();
            throw new ClientContainerException("You haven't specify a jar, an ear file or class name as argument. See the Usage.");
        }
        String className = null;
        if (!userArg.toLowerCase().endsWith(".jar") && !userArg.toLowerCase().endsWith(".ear")) {
            className = userArg;
            fileMode = false;
        } else {
            fileMode = true;
            fileName = userArg;
        }
        IDeployable deployable = null;
        if (fileMode) {
            File argFile2 = new File(fileName);
            IArchive archive = ArchiveManager.getInstance().getArchive((Object)argFile2);
            try {
                deployable = DeployableHelper.getDeployable((IArchive)archive);
            }
            catch (DeployableHelperException e) {
                throw new Exception("Cannot get a deployable for the archive '" + archive + "'", e);
            }
            if (deployable instanceof EARDeployable) {
                deployable = UnpackDeployableHelper.unpack((IDeployable)((EARDeployable)deployable), (String)"client-deployer");
            }
        }
        File workDir = new File(System.getProperty("java.io.tmpdir"));
        if (this.applyWsGen && fileMode) {
            try {
                argFile = new File(fileName);
                if (!argFile.exists()) {
                    throw new ClientContainerException("The specified file '" + fileName + "' doesn't exists.");
                }
                manifest = new JarFile(argFile).getManifest();
                if (manifest == null) {
                    throw new ClientContainerException("No manifest was found inside the file" + argFile);
                }
                attributes = manifest.getMainAttributes();
                if (attributes == null) {
                    throw new ClientContainerException("No attributes were found in the manifest of the file '" + argFile + "'.");
                }
                String archiveVersion = attributes.getValue("WsGen-JOnAS-Version");
                if (!Version.getNumber().equals(archiveVersion)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"Archive was not compiled with the latest WsGen. Regenerating ...");
                    WsGen wsGen = new WsGen();
                    Config config = new Config();
                    String deployablePath = URLUtils.urlToFile((URL)deployable.getArchive().getURL()).getPath();
                    config.setInputname(deployablePath);
                    config.setOut(workDir);
                    String path = wsGen.execute(config, deployable);
                    if (!path.equals(deployablePath)) {
                        IArchive archive = ArchiveManager.getInstance().getArchive((Object)new File(path));
                        EARDeployable newDeployable = (EARDeployable)DeployableHelper.getDeployable((IArchive)archive);
                        deployable = UnpackDeployableHelper.unpack((IDeployable)newDeployable, (File)workDir, (String)newDeployable.getShortName(), (boolean)false);
                    }
                }
            }
            catch (Exception e) {
                throw new ClientContainerException("Cannot apply WsGen on the client archive : " + userArg, e);
            }
        }
        if (this.applyGenClientStub && fileMode) {
            try {
                argFile = new File(fileName);
                if (!argFile.exists()) {
                    throw new ClientContainerException("The specified file '" + fileName + "' doesn't exists.");
                }
                ClientStubGen stubGen = new ClientStubGen();
                Config config = new Config();
                String deployablePath = URLUtils.urlToFile((URL)deployable.getArchive().getURL()).getPath();
                config.setInputname(deployablePath);
                config.setOut(workDir);
                String path = stubGen.execute(config, deployable);
                if (!path.equals(deployablePath)) {
                    IArchive archive = ArchiveManager.getInstance().getArchive((Object)new File(path));
                    IDeployable newDeployable = DeployableHelper.getDeployable((IArchive)archive);
                    deployable = UnpackDeployableHelper.unpack((IDeployable)newDeployable, (File)workDir, (String)newDeployable.getShortName(), (boolean)false);
                }
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.WARN, (Object)("Cannot apply GenClientStub on the client archive : " + userArg), (Throwable)e);
            }
        }
        this.clientJarFile = null;
        if (deployable != null) {
            this.clientJarFile = deployable instanceof EARDeployable ? this.extractAndAnalyzeEar((EARDeployable)deployable) : URLUtils.urlToFile((URL)deployable.getArchive().getURL());
        } else if (fileName != null) {
            this.clientJarFile = new File(fileName);
        }
        System.setProperty("javax.xml.soap.SOAPConnectionFactory", "com.sun.xml.messaging.saaj.client.p2p.HttpSOAPConnectionFactory");
        System.setProperty("javax.xml.soap.SOAPFactory", "com.sun.xml.messaging.saaj.soap.ver1_1.SOAPFactory1_1Impl");
        System.setProperty("javax.xml.soap.MetaFactory", "com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl");
        System.setProperty("javax.xml.soap.MessageFactory", "com.sun.xml.messaging.saaj.soap.ver1_1.SOAPMessageFactory1_1Impl");
        System.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.carol.rmi.multi.MultiPRODelegate");
        System.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        System.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        System.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer");
        System.setProperty("javax.rmi.CORBA.UtilClass", "org.ow2.carol.util.delegate.UtilDelegateImpl");
        System.setProperty(IIOP_INTERCEPTOR + OTSORBInitializer.class.getName(), "");
        System.setProperty(IIOP_INTERCEPTOR + SecurityInitializer.class.getName(), "");
        System.setProperty(IIOP_INTERCEPTOR + HAInterceptorInitializer.class.getName(), "");
        URL urlCarolFile = null;
        if (this.carolFile != null) {
            File fCarol = new File(this.carolFile);
            if (!fCarol.exists()) {
                throw new ClientContainerException("The file '" + this.carolFile + "' was not found.");
            }
            if (!fCarol.isFile()) {
                throw new ClientContainerException("The file '" + this.carolFile + "' is not a valid file. Maybe a directory ?");
            }
            if (!fCarol.getName().equals(CAROL_FILE)) {
                throw new ClientContainerException("The file '" + this.carolFile + "' must be named '" + CAROL_FILE + "'.");
            }
            try {
                urlCarolFile = fCarol.toURL();
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"Using carol.properties file specified by the user on command line");
                }
            }
            catch (MalformedURLException mue) {
                throw new ClientContainerException("Error when building an URL for the file '" + fCarol + "'.", mue);
            }
        }
        if (urlCarolFile == null && fileMode) {
            URL tmpUrl = null;
            try {
                tmpUrl = this.clientJarFile.toURL();
            }
            catch (MalformedURLException mue) {
                throw new ClientContainerException("Error when building an URL for the file '" + this.clientJarFile + "'.", mue);
            }
            URLClassLoader tmpCl = new URLClassLoader(new URL[]{tmpUrl}, null);
            urlCarolFile = tmpCl.getResource(CAROL_FILE);
            if (urlCarolFile != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Using carol.properties file of the '" + this.clientJarFile + "' file."));
            }
        }
        if (urlCarolFile != null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Init carol with URL '" + urlCarolFile + "'."));
            }
            ConfigurationRepository.init(urlCarolFile);
        } else {
            ConfigurationRepository.init();
        }
        ConfigurationRepository.addInterceptors((String)"iiop", (String)"org.ow2.jonas.security.iiop.Csiv2Initializer");
        System.setProperty("java.naming.factory.initial", ClientInitialContextFactory.class.getName());
        if (fileMode) {
            manifest = new JarFile(this.clientJarFile).getManifest();
            if (manifest == null) {
                throw new ClientContainerException("No manifest was found inside the file" + this.clientJarFile);
            }
            attributes = manifest.getMainAttributes();
            if (attributes == null) {
                throw new ClientContainerException("No attributes were found in the manifest of the file '" + this.clientJarFile + "'.");
            }
            this.mainClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
        } else {
            this.mainClass = className;
        }
        if (!fileMode) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            URLClassLoader clientCL = new URLClassLoader(this.getUserClasspathUrls(), tccl);
            Thread.currentThread().setContextClassLoader(clientCL);
            this.invokeClient(null);
            return;
        }
        if (this.mainClass == null || this.mainClass.length() == 0) {
            throw new ClientContainerException("No main class was found inside the Manifest  of the file '" + this.clientJarFile + "'. This attribute is required to launch the application client.");
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Using Main-Class :" + this.mainClass));
        }
        URL clientJarURL = URLUtils.fileToURL((File)this.clientJarFile);
        URL[] urlsClient = null;
        if (this.extensionsURLs != null) {
            urlsClient = new URL[this.extensionsURLs.length + 1];
            for (int i = 0; i < this.extensionsURLs.length; ++i) {
                urlsClient[i] = this.extensionsURLs[i];
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("Adding " + this.extensionsURLs[i] + " to the urls of the client"));
            }
            urlsClient[this.extensionsURLs.length] = clientJarURL;
        } else {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Only one url for urls of client");
            }
            urlsClient = new URL[]{clientJarURL};
        }
        URLClassLoader clientClassloader = new URLClassLoader(urlsClient, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(clientClassloader);
        ClientContainerDeploymentDesc clientDD = null;
        if (this.extensionsURLs != null) {
            EjbDeploymentDescManager.getInstance().addClassLoaderUrlMapping((ClassLoader)clientClassloader, this.extensionsURLs);
        }
        try {
            clientDD = ClientDeploymentDescManager.getInstance().getDeploymentDesc(clientJarURL, (ClassLoader)clientClassloader, (ClassLoader)this.earClassLoader);
        }
        catch (ClientContainerDeploymentDescException e) {
            err = "Cannot read the deployment descriptors '" + clientJarURL + "'";
            this.error(err);
            throw new ClientContainerException(err, e);
        }
        try {
            this.setClientEnvironment(clientDD);
        }
        catch (Exception e) {
            err = "Error when populating ";
            this.error(err);
            throw new ClientContainerException(err, e);
        }
        String jaasFile = clientDD.getJaasFile();
        String jaasEntry = clientDD.getJaasEntry();
        String username = clientDD.getUsername();
        String password = clientDD.getPassword();
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Using jaas file = " + jaasFile));
        }
        String jaasConfigFile = null;
        if (jaasFile != null) {
            jaasConfigFile = "jar:" + clientJarURL.toExternalForm() + "!/" + jaasFile;
            System.setProperty("java.security.auth.login.config", jaasConfigFile);
        }
        Object ch = null;
        if (username != null && password != null) {
            ch = new NoInputCallbackHandler(username, password);
            this.info("Using the login/password specified in the jonas-client.xml file with a specific CallbackHandler");
        } else {
            String ddCallbackHandler = clientDD.getCallbackHandler();
            if (ddCallbackHandler != null) {
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Using '" + ddCallbackHandler + "' class as CallbackHandler."));
                }
                Class<?> clazz = null;
                try {
                    clazz = clientClassloader.loadClass(ddCallbackHandler);
                }
                catch (Exception e) {
                    throw new ClientContainerException("There was an error while trying to instantiate the class '" + ddCallbackHandler + "' which is specified in the application.xml as CallbackHandler class", e);
                }
                try {
                    ch = (CallbackHandler)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new ClientContainerException("Error while triyng to cast the class '" + ddCallbackHandler + "' to CallbackHandler interface, maybe the specified class doesn't implement this interface.", e);
                }
            }
        }
        if (ch != null) {
            if (jaasFile == null) {
                String sysJaasConfig = System.getProperty("java.security.auth.login.config");
                if (sysJaasConfig == null) {
                    throw new ClientContainerException("You have defined that you want use a CallbackHandler but you haven't specify the jaas file to use for the JAAS configuration.");
                }
                this.info("Using system defined JAAS config file" + sysJaasConfig);
            }
            if (jaasEntry == null) {
                throw new ClientContainerException("You have defined that you want use a CallbackHandler but you haven't specify the jaas entry to use from the JAAS config file.");
            }
            this.info("Using JAAS loginContext '" + jaasEntry + "' from the file '" + jaasConfigFile + "'.");
            try {
                LoginContext lc = new LoginContext(jaasEntry, (CallbackHandler)ch);
                lc.login();
            }
            catch (Exception e) {
                String err2 = "Can not use the JAAS authentication";
                this.error(err2);
                throw new ClientContainerException(err2, e);
            }
        }
        this.invokeClient(clientDD.getCarDeployableMetadata());
    }

    private void invokeClient(ICarDeployableMetadata carDeployableMetadata) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader clientClassloader = Thread.currentThread().getContextClassLoader();
        if (this.logger.isLoggable(BasicLevel.DEBUG) && clientClassloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)clientClassloader;
            URL[] urls = urlClassLoader.getURLs();
            this.logger.log(BasicLevel.DEBUG, (Object)"URLs of the classloader :");
            for (int u = 0; u < urls.length; ++u) {
                this.logger.log(BasicLevel.DEBUG, (Object)("URL[" + u + "] = " + urls[u]));
            }
        }
        Class<?> clazz = clientClassloader.loadClass(this.mainClass);
        if (this.clientJarFile != null) {
            ArchiveInjection archiveInjection = new ArchiveInjection(carDeployableMetadata);
            try {
                archiveInjection.init(clazz);
            }
            catch (ArchiveInjectionException e) {
                this.logger.log(BasicLevel.ERROR, (Object)"Cannot make class initialization.", (Throwable)e);
            }
        }
        Class[] argList = new Class[]{this.args.getClass()};
        Method meth = clazz.getMethod("main", argList);
        String[] newArgs = new String[this.appArgs.size() - 1];
        String txtArgs = "";
        for (int i = 0; i < newArgs.length; ++i) {
            newArgs[i] = this.appArgs.get(i + 1);
            txtArgs = txtArgs + newArgs[i] + " ";
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Starting the application client with the arguments '" + txtArgs + "'."));
        }
        this.info("Starting client...");
        meth.invoke(null, new Object[]{newArgs});
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"End of main method");
        }
    }

    private void setClientEnvironment(ClientContainerDeploymentDesc clientDD) throws NamingException, ClientContainerException {
        IENCBindingHolder encBindingHolder;
        List webServiceRefBindings;
        LinkRef lref;
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"");
        }
        JComponentContextFactory ccf = null;
        try {
            this.naming = SingletonNamingManager.getInstance();
            ccf = SingletonComponentContextFactory.getInstance();
            this.naming.setJComponentContextFactory(ccf);
        }
        catch (NamingException e) {
            throw new ClientContainerException("Error when getting the reference to the Naming manager", e);
        }
        Context javaCtx = ccf.createComponentContext("ClientContainer");
        this.naming.setClientContainerComponentContext(javaCtx);
        Context envCtx = javaCtx.createSubcontext("comp/env");
        IEnvEntryDesc[] envt = clientDD.getEnvEntryDesc();
        for (int i = 0; i < envt.length; ++i) {
            String name = envt[i].getName();
            Object obj = envt[i].getValue();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Binding object " + name + " -> " + obj));
            }
            envCtx.rebind(name, obj);
        }
        IResourceRefDesc[] resref = clientDD.getResourceRefDesc();
        for (int i = 0; i < resref.length; ++i) {
            String name = resref[i].getName();
            String resname = resref[i].getJndiName();
            String type = resref[i].getTypeName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Linking resource " + name + " -> " + resname));
            }
            if (type.equalsIgnoreCase("java.net.URL")) {
                Reference ref = new Reference("java.net.URL", "org.ow2.jonas.lib.naming.URLFactory", null);
                StringRefAddr refAddr = new StringRefAddr("url", resname);
                ref.add(refAddr);
                envCtx.rebind(name, (Object)ref);
                continue;
            }
            lref = new LinkRef(resname);
            envCtx.rebind(name, (Object)lref);
        }
        IResourceEnvRefDesc[] resEnvref = clientDD.getResourceEnvRefDesc();
        for (int i = 0; i < resEnvref.length; ++i) {
            String name = resEnvref[i].getName();
            String resname = resEnvref[i].getJndiName();
            lref = new LinkRef(resname);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Linking resource environment " + name + " -> " + resname));
            }
            envCtx.rebind(name, (Object)lref);
        }
        EjbRefDesc[] ejbref = clientDD.getEjbRefDesc();
        for (int i = 0; i < ejbref.length; ++i) {
            String name = ejbref[i].getEjbRefName();
            String ejbname = null;
            ejbname = ejbref[i].getJndiName();
            LinkRef lref2 = new LinkRef(ejbname);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Linking ejb " + name + " -> " + ejbname));
            }
            envCtx.rebind(name, (Object)lref2);
        }
        IServiceRefDesc[] serviceRefs = clientDD.getServiceRefDesc();
        if (serviceRefs.length != 0) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            JServiceFactory factory = ClientJServiceFactoryFinder.getJOnASServiceFactory();
            for (int i = 0; i < serviceRefs.length; ++i) {
                String refname = serviceRefs[i].getServiceRefName();
                Reference ref = factory.getServiceReference(serviceRefs[i], loader);
                envCtx.rebind(refname, (Object)ref);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("Adding service-ref 'java:comp/env/" + refname + "'"));
            }
        }
        if ((webServiceRefBindings = (encBindingHolder = clientDD.getENCBindingHolder()).getWebServicesBindings()) != null) {
            for (IENCBinding webServiceRefBinding : webServiceRefBindings) {
                String encName = webServiceRefBinding.getName();
                IJaxwsWebServiceRef jaxwsWebServiceRef = (IJaxwsWebServiceRef)webServiceRefBinding.getValue();
                JAXWSWebServiceRefBuilder builder = new JAXWSWebServiceRefBuilder();
                Reference ref = null;
                try {
                    ref = builder.build(jaxwsWebServiceRef);
                }
                catch (NamingException e) {
                    throw new ClientContainerException("Cannot build the Reference for @WebServiceRef(" + jaxwsWebServiceRef.getName() + ")", e);
                }
                envCtx.rebind(encName, (Object)ref);
            }
        }
        PersistenceUnitRefDesc[] puref = clientDD.getPersistenceUnitRefs();
        for (int i = 0; i < puref.length; ++i) {
            String refName = puref[i].getRefName();
            String unitName = puref[i].getName();
            if (this.persistenceUnitManager == null) break;
            EntityManagerFactory emf = this.persistenceUnitManager.getEntityManagerFactory(unitName);
            envCtx.rebind(refName, (Object)emf);
            if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("Adding persistence-unit-ref 'java:comp/env/" + refName + "'"));
        }
        MessageDestinationRefDesc[] mdref = clientDD.getMessageDestinationRefDesc();
        for (int i = 0; i < mdref.length; ++i) {
            String name = mdref[i].getMessageDestinationRefName();
            String mdname = null;
            mdname = mdref[i].getJndiName();
            LinkRef lref3 = new LinkRef(mdname);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Linking message-destination-ref " + name + " -> " + mdname));
            }
            envCtx.rebind(name, (Object)lref3);
        }
    }

    private void analyzeArgs() throws Exception {
        for (int argn = 0; argn < this.args.length; ++argn) {
            String arg = this.args[argn];
            try {
                if (arg.equals("-tmpDir")) {
                    this.tmpDir = this.args[++argn];
                    continue;
                }
                if (arg.equals("-jarClient")) {
                    this.jarClient = this.args[++argn];
                    continue;
                }
                if (arg.equals("-traceFile")) {
                    this.clientTraceFile = this.args[++argn];
                    continue;
                }
                if (arg.equals("-carolFile")) {
                    this.carolFile = this.args[++argn];
                    continue;
                }
                if (arg.equals("-cp")) {
                    this.classpath = this.args[++argn];
                    continue;
                }
                if (arg.equals("-nowsgen")) {
                    this.applyWsGen = false;
                    continue;
                }
                if (arg.equals("-genclientstub")) {
                    this.applyGenClientStub = true;
                    continue;
                }
                if (arg.equals("--help") || arg.equals("-help") || arg.equals("-h") || arg.equals("-?")) {
                    this.usage();
                    System.exit(1);
                }
                this.appArgs.add(arg);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new ClientContainerException("A required parameter was missing after the argument" + arg);
            }
        }
    }

    private void usage() {
        System.out.println("Usage of this client :");
        System.out.println("-------------------------------------------------------------------");
        System.out.println("java -jar client.jar <client.jar|app.ear|className> [options]");
        System.out.println("-------------------------------------------------------------------");
        System.out.println(" -jarClient   : Specify the client jar to use of the ear if many.");
        System.out.println(" -traceFile   : Specify the configuration file to use for the traces\n                of this client instead of the default file\n                (traceclient.properties) present in client.jar.");
        System.out.println(" -carolFile   : Specify the carol.properties file to use instead of \n                the default carol.properties file of the client.jar");
        System.out.println(" -tmpDir      : Specify the temp directory where unpack the ear.");
        System.out.println(" -cp          : Specify the classpath to use for the jar client.");
        System.out.println(" -nowsgen     : Specify if the Container shouldn't use Automated WsGen.");
        System.out.println("-------------------------------------------------------------------");
        System.out.println("  --help  : Display this help.");
        System.out.println("  -help   : Display this help.");
        System.out.println("  -h      : Display this help.");
        System.out.println("  -?      : Display this help.");
        System.out.println("-------------------------------------------------------------------");
    }

    private File extractAndAnalyzeEar(EARDeployable earDeployable) throws Exception {
        File tmpFileDir;
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"");
        }
        URL earUrl = null;
        try {
            earUrl = earDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new ClientContainerException("Cannot get url with deployable '" + earDeployable + "'.", e);
        }
        URL[] arrURL = new URL[]{earUrl};
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader loaderCls = new URLClassLoader(arrURL, currentLoader);
        EarDeploymentDesc earDD = null;
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Getting the deployment descriptor of the file" + earDeployable));
        }
        try {
            earDD = EarDeploymentDescManager.getDeploymentDesc((EARDeployable)earDeployable, (ClassLoader)loaderCls);
        }
        catch (EarDeploymentDescException e) {
            String err = "Error in the Deployment descriptor from deployable '" + earDeployable + "'";
            throw new ClientContainerException(err, e);
        }
        Map userToRoleMapping = earDD.getUserToRoleMapping();
        if (userToRoleMapping != null) {
            for (String principalName : userToRoleMapping.keySet()) {
                List roles = (List)userToRoleMapping.get(principalName);
                String[] roleNames = roles.toArray(new String[roles.size()]);
                JPolicyUserRoleMapping.addGlobalUserToRoleMapping((String)principalName, (String[])roleNames);
            }
        }
        String[] ejbTags = earDD.getEjbTags();
        Web[] webTags = earDD.getWebTags();
        String[] clientTags = earDD.getClientTags();
        String[] altDDEjbs = earDD.getAltDDEjbs();
        String[] altDDWebs = earDD.getAltDDWebs();
        String[] altDDClients = earDD.getAltDDClients();
        JarList ejbsList = new JarList(ejbTags);
        JarList clientsList = new JarList(clientTags);
        String[] webURIs = new String[webTags.length];
        for (int i = 0; i < webURIs.length; ++i) {
            webURIs[i] = webTags[i].getWebUri();
        }
        JarList websList = new JarList(webURIs);
        String tempDir = null;
        if (this.tmpDir != null) {
            tempDir = this.tmpDir;
            this.info("Use your specified temp directory '" + tempDir + "'.");
        } else {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Using temp directory '" + tempDir + "'."));
        }
        if (!(tmpFileDir = new File(tempDir)).exists() || !tmpFileDir.isDirectory()) {
            throw new ClientContainerException("The temp directory '" + tempDir + "' doesn't exist or is not a directory.");
        }
        if (!tmpFileDir.canWrite()) {
            throw new ClientContainerException("Can not write to the temporary directory '" + tempDir + "'.");
        }
        URL dirUnpackURL = null;
        if (earDeployable.getOriginalDeployable() == null) {
            try {
                EARDeployable unpackedDeployable = (EARDeployable)UnpackDeployableHelper.unpack((IDeployable)earDeployable, (File)tmpFileDir, null);
                dirUnpackURL = unpackedDeployable.getArchive().getURL();
            }
            catch (Exception e) {
                String err = "Error while unpacking the file '" + earUrl + "'";
                throw new ClientContainerException(err, e);
            }
        } else {
            dirUnpackURL = earDeployable.getArchive().getURL();
        }
        EarClassPathManager earCPManager = null;
        try {
            earCPManager = new EarClassPathManager(clientsList, dirUnpackURL);
        }
        catch (EarClassPathManagerException e) {
            String err = "Error while creating the Ear class path manager of the ear : '" + earUrl + "'";
            this.error(err + " : " + e.getMessage());
            throw new ClientContainerException(err, e);
        }
        URL[] classpathURLs = null;
        try {
            classpathURLs = earCPManager.getResolvedClassPath();
        }
        catch (EarClassPathManagerException e) {
            String err = "Error while trying to resolve the classpath of the ejbjars and wars of the ear : '" + earUrl + "'";
            this.error(err + " : " + e.getMessage());
            throw new ClientContainerException(err, e);
        }
        List libDeployables = earDeployable.getLibDeployables();
        ArrayList<URL> updatedClasspathURLs = new ArrayList<URL>();
        if (classpathURLs != null) {
            for (URL classpathURL : classpathURLs) {
                updatedClasspathURLs.add(classpathURL);
            }
        }
        for (LibDeployable libDeployable : libDeployables) {
            URL libDeployableURL = null;
            try {
                libDeployableURL = libDeployable.getArchive().getURL();
            }
            catch (ArchiveException e) {
                this.logger.log(BasicLevel.ERROR, (Object)("libs: unable to get URL from '" + libDeployableURL + "'."));
                continue;
            }
            if (updatedClasspathURLs.contains(libDeployableURL)) continue;
            updatedClasspathURLs.add(libDeployableURL);
        }
        classpathURLs = updatedClasspathURLs.toArray(new URL[updatedClasspathURLs.size()]);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("EAR : ejbs = " + ejbsList));
            this.logger.log(BasicLevel.DEBUG, (Object)("EAR : webs = " + websList));
            this.logger.log(BasicLevel.DEBUG, (Object)("EAR : clientUrls = " + clientsList));
        }
        currentLoader = Thread.currentThread().getContextClassLoader();
        this.earClassLoader = new URLClassLoader(new URL[0], currentLoader);
        URL[] jarUrls = null;
        URL[] warUrls = null;
        URL[] clientUrls = null;
        try {
            jarUrls = ejbsList.getURLs(dirUnpackURL.toExternalForm());
            warUrls = websList.getURLs(dirUnpackURL.toExternalForm());
            clientUrls = clientsList.getURLs(dirUnpackURL.toExternalForm());
        }
        catch (JarListException e) {
            String err = "Error while getting the URLs from jarlist of the ear : '" + earUrl + "'";
            throw new ClientContainerException(err, e);
        }
        List carDeployables = earDeployable.getCARDeployables();
        if (carDeployables != null) {
            EasyBeansClassLoader ezbClassLoader = new EasyBeansClassLoader(clientUrls, currentLoader);
            this.configureExtraDialects();
            for (CARDeployable carDeployable : carDeployables) {
                this.updatePersistenceUnitManager(this.getPersistenceUnitManager((IDeployable<?>)carDeployable, (ClassLoader)ezbClassLoader));
            }
        }
        String altdd = null;
        File fAltDD = null;
        URL[] clientsAltDDs = new URL[altDDClients.length];
        for (int i = 0; i < altDDClients.length; ++i) {
            if (altDDClients[i] == null || (altdd = altDDClients[i]) == null) continue;
            try {
                fAltDD = new File(new URL(dirUnpackURL.toExternalForm() + File.separator + altdd).getFile());
                clientsAltDDs[i] = fAltDD.getCanonicalFile().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                String err = "Can't build URL for alt-dd '" + altdd;
                this.error(err + "': " + e.getMessage());
                throw new ClientContainerException(err, e);
            }
            catch (IOException ioe) {
                String err = "Can't get canonicalFile() for the file '" + fAltDD;
                this.error(err + "': " + ioe.getMessage());
                throw new ClientContainerException(err, ioe);
            }
        }
        URL[] ejbsAltDDs = new URL[altDDEjbs.length];
        for (int i = 0; i < altDDEjbs.length; ++i) {
            if (altDDEjbs[i] == null || (altdd = altDDEjbs[i]) == null) continue;
            try {
                fAltDD = new File(new URL(dirUnpackURL.toExternalForm() + File.separator + altdd).getFile());
                ejbsAltDDs[i] = fAltDD.getCanonicalFile().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                String err = "Can't build URL for alt-dd '" + altdd;
                this.error(err + "': " + e.getMessage());
                throw new ClientContainerException(err, e);
            }
            catch (IOException ioe) {
                String err = "Can't get canonicalFile() for the file '" + fAltDD;
                this.error(err + "': " + ioe.getMessage());
                throw new ClientContainerException(err, ioe);
            }
        }
        URL[] websAltDDs = new URL[altDDWebs.length];
        for (int i = 0; i < altDDWebs.length; ++i) {
            if (altDDWebs[i] == null || (altdd = altDDWebs[i]) == null) continue;
            try {
                fAltDD = new File(new URL(dirUnpackURL.toExternalForm() + File.separator + altdd).getFile());
                websAltDDs[i] = fAltDD.getCanonicalFile().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                String err = "Can't build URL for alt-dd '" + altdd;
                this.error(err + "': " + e.getMessage());
                throw new ClientContainerException(err, e);
            }
            catch (IOException ioe) {
                String err = "Can't get canonicalFile() for the file '" + fAltDD;
                this.error(err + "': " + ioe.getMessage());
                throw new ClientContainerException(err, ioe);
            }
        }
        EjbDeploymentDescManager.getInstance().setAvailableEjbJarsAndAltDDs((ClassLoader)this.earClassLoader, jarUrls, ejbsAltDDs);
        WebDeploymentDescManager.getInstance().setAltDD((ClassLoader)this.earClassLoader, warUrls, websAltDDs);
        ClientDeploymentDescManager.getInstance().setAltDD((ClassLoader)this.earClassLoader, clientUrls, clientsAltDDs);
        URL[] userURLs = this.getUserClasspathUrls();
        this.extensionsURLs = new URL[jarUrls.length + classpathURLs.length + userURLs.length];
        System.arraycopy(jarUrls, 0, this.extensionsURLs, 0, jarUrls.length);
        System.arraycopy(classpathURLs, 0, this.extensionsURLs, jarUrls.length, classpathURLs.length);
        System.arraycopy(userURLs, 0, this.extensionsURLs, jarUrls.length + classpathURLs.length, userURLs.length);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"Extensions urls :");
            for (int ii = 0; ii < this.extensionsURLs.length; ++ii) {
                this.logger.log(BasicLevel.DEBUG, (Object)("url[" + ii + "] = " + this.extensionsURLs[ii]));
            }
        }
        if (clientUrls.length == 0) {
            throw new ClientContainerException("No java client was found in the application.xml file of the Ear '" + earUrl + "'.");
        }
        File fClient = null;
        if (this.jarClient != null) {
            File ff = null;
            boolean found = false;
            for (int f = 0; f < clientUrls.length && !found; ++f) {
                ff = new File(clientUrls[f].getFile());
                if (!ff.getPath().endsWith(this.jarClient)) continue;
                found = true;
                fClient = ff;
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("Found a matching client with the name " + ff));
            }
            if (!found) {
                throw new ClientContainerException("No client with the name '" + this.jarClient + "' was found in this Ear file");
            }
        } else {
            fClient = new File(clientUrls[0].getFile());
            if (clientUrls.length > 1) {
                this.warn("There are " + clientUrls.length + " clients in this ear, choosing the first one : " + fClient.getName());
            }
        }
        this.info("Use the application client '" + fClient + "' of the Ear '" + earUrl + "'.");
        return fClient;
    }

    private URL[] getUserClasspathUrls() {
        if (this.classpath == null) {
            return new URL[0];
        }
        String sep = File.pathSeparator;
        ArrayList<URL> clUser = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(this.classpath, sep);
        while (tokenizer.hasMoreTokens()) {
            File file = new File(tokenizer.nextToken());
            try {
                clUser.add(file.toURL());
            }
            catch (MalformedURLException mue) {
                this.logger.log(BasicLevel.WARN, (Object)("Cannot transform to URL the file : '" + file + "'"), (Throwable)mue);
            }
        }
        return clUser.toArray(new URL[0]);
    }

    private PersistenceUnitManager getPersistenceUnitManager(IDeployable<?> deployable, ClassLoader classLoader) {
        PersistenceUnitManager persistenceUnitManager = null;
        try {
            persistenceUnitManager = PersistenceXmlFileAnalyzer.analyzePersistenceXmlFile((IArchive)deployable.getArchive(), (ClassLoader)classLoader);
        }
        catch (PersistenceXmlFileAnalyzerException e) {
            throw new IllegalStateException("Failure when analyzing the persistence.xml file", e);
        }
        return persistenceUnitManager;
    }

    private void updatePersistenceUnitManager(PersistenceUnitManager extraPersistenceUnitManager) {
        if (this.persistenceUnitManager != null) {
            if (extraPersistenceUnitManager != null) {
                this.persistenceUnitManager.addExtraPersistenceUnitInfos(extraPersistenceUnitManager.getPersistenceUnitInfos());
            }
        } else {
            this.persistenceUnitManager = extraPersistenceUnitManager;
        }
    }

    protected void configureExtraDialects() {
        block2: {
            try {
                Class<?> hibernateDialectClass = Embedded.class.getClassLoader().loadClass("org.hibernate.dialect.DialectFactory");
                Field mapper = hibernateDialectClass.getDeclaredField("MAPPERS");
                mapper.setAccessible(true);
                Map map = null;
                map = (Map)mapper.get(null);
                Class<?> versionInsensitiveMapperClass = Embedded.class.getClassLoader().loadClass("org.hibernate.dialect.DialectFactory$VersionInsensitiveMapper");
                Constructor<?> c = versionInsensitiveMapperClass.getConstructor(String.class);
                Object oracle9idialect = c.newInstance("org.hibernate.dialect.Oracle9iDialect");
                map.put("Oracle9i Enterprise Edition", oracle9idialect);
                Object oracle10Dialect = c.newInstance("org.hibernate.dialect.OracleDialect");
                map.put("Oracle Database 10g Release 10.2.0.3.0 - 64bit Production", oracle10Dialect);
                mapper.setAccessible(false);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) break block2;
                this.logger.log(BasicLevel.DEBUG, (Object)"Cannot configure some dialects used by Hibernate", (Throwable)e);
            }
        }
    }

    private void info(String s) {
        this.logger.log(BasicLevel.INFO, (Object)s);
    }

    private void error(String s) {
        this.logger.log(BasicLevel.ERROR, (Object)s);
    }

    private void warn(String s) {
        this.logger.log(BasicLevel.WARN, (Object)s);
    }
}

