/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.osgi.BundleProxyClassLoader;
import org.eclipse.persistence.internal.jpa.deployment.osgi.OSGiInitializer;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.osgi.framework.Bundle;

public class OSGiPersistenceInitializationHelper
extends PersistenceInitializationHelper {
    private String initializerClassName = null;
    public static final String EQUINOX_INITIALIZER_NAME = "org.eclipse.persistence.internal.jpa.deployment.osgi.equinox.EquinoxInitializer";
    private static Map<String, Bundle> puToBundle = Collections.synchronizedMap(new HashMap());
    private static Map<Bundle, String[]> bundleToPUs = Collections.synchronizedMap(new HashMap());

    public static void addBundle(Bundle bundle, String[] persistenceUnitNames) {
        for (int i = 0; i < persistenceUnitNames.length; ++i) {
            String name = persistenceUnitNames[i];
            puToBundle.put(name, bundle);
        }
        bundleToPUs.put(bundle, persistenceUnitNames);
    }

    public static void removeBundle(Bundle bundle) {
        String[] persistenceUnitNames = bundleToPUs.remove(bundle);
        if (persistenceUnitNames != null) {
            for (int i = 0; i < persistenceUnitNames.length; ++i) {
                String name = persistenceUnitNames[i];
                puToBundle.remove(name);
            }
        }
    }

    public OSGiPersistenceInitializationHelper(String initializerClassName) {
        this.initializerClassName = initializerClassName;
    }

    public ClassLoader getClassLoader(String emName, Map properties) {
        ClassLoader bundleClassLoader = null;
        if (properties != null) {
            bundleClassLoader = (ClassLoader)properties.get("eclipselink.classloader");
        }
        if (bundleClassLoader == null) {
            Bundle bundle = puToBundle.get(emName);
            if (bundle == null) {
                throw EntityManagerSetupException.couldNotFindPersistenceUnitBundle(emName);
            }
            bundleClassLoader = new BundleProxyClassLoader(bundle);
        }
        return bundleClassLoader;
    }

    public JPAInitializer getInitializer(ClassLoader classLoader, Map m) {
        if (this.initializerClassName != null) {
            try {
                Class<?> initializerClass = Class.forName(this.initializerClassName);
                Class[] argTypes = new Class[]{ClassLoader.class, Map.class, PersistenceInitializationHelper.class};
                Object[] args = new Object[]{classLoader, m, this};
                JPAInitializer initializer = (JPAInitializer)initializerClass.getConstructor(argTypes).newInstance(args);
                return initializer;
            }
            catch (Exception e) {
                AbstractSessionLog.getLog().log(1, LoggingLocalization.buildMessage("osgi_initializer_failed", new Object[]{this.initializerClassName, e}));
            }
        }
        return new OSGiInitializer(classLoader);
    }
}

