/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;

public abstract class AggregateNode
extends Node {
    private boolean distinct = false;

    public String resolveAttribute() {
        Node arg = this.getLeft();
        return arg.isDotNode() ? ((DotNode)arg).resolveAttribute() : null;
    }

    public Class resolveClass(GenerationContext context) {
        return this.getLeft().resolveClass(context);
    }

    public boolean isAggregateNode() {
        return true;
    }

    public boolean usesDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public Expression generateExpression(GenerationContext context) {
        String name = this.getAsString();
        Expression aggregateExpr = context.expressionFor(name);
        if (aggregateExpr == null) {
            Expression arg = this.getLeft().generateExpression(context);
            if (this.usesDistinct()) {
                arg = arg.distinct();
            }
            aggregateExpr = this.addAggregateExression(arg);
            context.addExpression(aggregateExpr, name);
        }
        return aggregateExpr;
    }

    protected abstract Expression addAggregateExression(Expression var1);
}

