/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.helper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.container.session.stateful.StatefulSessionFactory;
import org.ow2.easybeans.proxy.client.AbsInvocationHandler;
import org.ow2.easybeans.proxy.client.ClientRPCInvocationHandler;
import org.ow2.easybeans.proxy.client.LocalCallInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyHelper {
    private ProxyHelper() {
    }

    public static <T> T getProxy(Factory<?, ?> factory, Class<T> interfaceClass, boolean isLocalProxy) {
        EZBContainer container = factory.getContainer();
        EZBServer server = container.getConfiguration().getEZBServer();
        String containerID = container.getId();
        String factoryName = factory.getBeanInfo().getName();
        boolean isStateful = false;
        if (factory instanceof StatefulSessionFactory) {
            isStateful = true;
        }
        Integer serverID = server.getID();
        AbsInvocationHandler handler = null;
        if (isLocalProxy) {
            handler = new LocalCallInvocationHandler(serverID, containerID, factoryName, isStateful);
        } else {
            handler = new ClientRPCInvocationHandler(containerID, factoryName, isStateful);
            try {
                ((ClientRPCInvocationHandler)handler).setRMIEnv(new InitialContext().getEnvironment());
            }
            catch (NamingException e) {
                throw new IllegalArgumentException("Unable to get environment", e);
            }
        }
        handler.setBusinessObjectMode(true);
        ClassLoader classLoader = interfaceClass.getClassLoader();
        handler.setInterfaceClass(interfaceClass);
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{interfaceClass}, (InvocationHandler)handler);
    }
}

