/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class PrepareTask
extends BaseTask {
    File basedir;
    boolean print = false;

    public void execute() throws BuildException {
        try {
            if (this.basedir == null || !this.basedir.isDirectory()) {
                throw new BuildException("The given base dir does not exist " + this.basedir);
            }
            Project project = Workspace.getProject(this.basedir);
            project.setExceptions(true);
            Properties properties = project.getFlattenedProperties();
            if (this.report() || this.report(project)) {
                throw new BuildException("Errors during Eclipse Path inspection");
            }
            this.copyProperties(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private void copyProperties(Properties flattened) {
        Enumeration<?> k = flattened.propertyNames();
        while (k.hasMoreElements()) {
            String key = (String)k.nextElement();
            String value = flattened.getProperty(key);
            if (this.isPrint()) {
                System.out.printf("%-20s = %s\n", key, value);
            }
            this.getProject().setProperty(key, value);
        }
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }
}

