/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make;

import aQute.bnd.service.MakePlugin;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.JarResource;
import aQute.lib.osgi.Resource;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeBnd
implements MakePlugin {
    static final Pattern JARFILE = Pattern.compile("(.+)\\.(jar|ipa)");

    @Override
    public Resource make(Builder builder, String destination, Map<String, String> argumentsOnMake) throws Exception {
        String type = argumentsOnMake.get("type");
        if (!"bnd".equals(type)) {
            return null;
        }
        String recipe = argumentsOnMake.get("recipe");
        if (recipe == null) {
            builder.error("No recipe specified on a make instruction for " + destination);
            return null;
        }
        File bndfile = builder.getFile(recipe);
        if (bndfile.isFile()) {
            Builder bchild = new Builder();
            bchild.setProperties(bndfile);
            bchild.setBase(builder.getBase());
            for (Object element : builder.getProperties().keySet()) {
                String key = (String)element;
                if (!key.startsWith("-") && !Character.isLowerCase(key.charAt(0)) || bchild.getProperties().containsKey(key)) continue;
                bchild.setProperty(key, builder.getProperty(key));
            }
            for (Jar jar : builder.getClasspath()) {
                bchild.addClasspath(jar);
            }
            String p = builder.getProperty("p");
            if (p == null) {
                p = builder.getBase().getName();
            }
            bchild.setProperty("p", p);
            Jar jar = bchild.build();
            Jar dot = builder.getTarget();
            if (builder.hasSources()) {
                for (String key : jar.getResources().keySet()) {
                    if (!key.startsWith("OSGI-OPT/src")) continue;
                    dot.putResource(key, jar.getResource(key));
                }
            }
            builder.getInfo(bchild, String.valueOf(bndfile.getName()) + ": ");
            return new JarResource(jar);
        }
        return null;
    }
}

