/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogTest
extends TestCase {
    static final Log log = LogFactory.getLog(LogTest.class);
    final boolean trace = log.isTraceEnabled();
    final int NUM = 10000;
    long start;
    long stop;
    long diff;

    public LogTest(String name) {
        super(name);
    }

    public void testSpeedWithSingleTraceStatement() {
        this.start = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("this is log statement number " + i + " from Bela"));
        }
        this.stop = System.currentTimeMillis();
        System.out.println("took " + (this.stop - this.start) + "ms for " + 10000 + " log statements");
    }

    public void testSpeedWithSingleTraceStatementLogIsTracePreset() {
        this.start = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            if (!this.trace) continue;
            log.trace((Object)("this is log statement number " + i + " from Bela"));
        }
        this.stop = System.currentTimeMillis();
        System.out.println("took " + (this.stop - this.start) + "ms for " + 10000 + " log statements");
    }

    public void testSpeedWithTwoTraceStatements() {
        this.start = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("this is log statement number " + i));
            log.trace((Object)" from Bela");
        }
        this.stop = System.currentTimeMillis();
        System.out.println("took " + (this.stop - this.start) + "ms for " + 10000 + " log statements");
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{LogTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

