/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.context;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.context.ServiceReferenceImpl;
import org.apache.felix.ipojo.context.ServiceRegistrationImpl;
import org.apache.felix.ipojo.util.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistry {
    private long m_serviceId = 1L;
    private List m_listeners = new ArrayList();
    private List m_regs = new ArrayList();
    private BundleContext m_context;
    private Logger m_logger;

    public ServiceRegistry(BundleContext context) {
        this.m_context = context;
        this.m_logger = new Logger(this.m_context, "Registry logger " + this.m_context.getBundle().getBundleId());
    }

    public void addServiceListener(ServiceListener arg0) {
        ListenerInfo info = new ListenerInfo();
        info.m_listener = arg0;
        info.m_filter = null;
        this.m_listeners.add(info);
    }

    public boolean ungetService(ComponentInstance instance, ServiceReference ref) {
        ServiceRegistrationImpl reg = ((ServiceReferenceImpl)ref).getServiceRegistration();
        if (reg.isValid()) {
            reg.ungetService(instance, reg.getService());
            return true;
        }
        return false;
    }

    public void removeServiceListener(ServiceListener arg0) {
        this.m_listeners.remove(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration registerService(ComponentInstance instance, String clazz, Object svcObj, Dictionary dict) {
        List list = this.m_regs;
        synchronized (list) {
            ServiceRegistrationImpl reg = new ServiceRegistrationImpl(this, instance, new String[]{clazz}, new Long(this.m_serviceId++), svcObj, dict);
            this.m_regs.add(reg);
            this.fireServiceChanged(new ServiceEvent(1, reg.getReference()));
            return reg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration registerService(ComponentInstance instance, String[] clazzes, Object svcObj, Dictionary dict) {
        List list = this.m_regs;
        synchronized (list) {
            ServiceRegistrationImpl reg = new ServiceRegistrationImpl(this, instance, clazzes, new Long(this.m_serviceId++), svcObj, dict);
            this.m_regs.add(reg);
            this.fireServiceChanged(new ServiceEvent(1, reg.getReference()));
            return reg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServiceChanged(ServiceEvent event) {
        List list = this.m_listeners;
        synchronized (list) {
            for (int i = 0; i < this.m_listeners.size(); ++i) {
                ListenerInfo info = (ListenerInfo)this.m_listeners.get(i);
                ServiceReference ref = event.getServiceReference();
                if (info.m_filter == null) {
                    info.m_listener.serviceChanged(event);
                }
                Dictionary props = ((ServiceReferenceImpl)ref).getProperties();
                if (info.m_filter == null || !info.m_filter.match(props)) continue;
                info.m_listener.serviceChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences(String className, String expr) throws InvalidSyntaxException {
        List list = this.m_regs;
        synchronized (list) {
            Filter filter = null;
            if (expr != null) {
                filter = this.m_context.createFilter(expr);
            }
            ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
            for (int i = 0; i < this.m_regs.size(); ++i) {
                ServiceRegistrationImpl reg = (ServiceRegistrationImpl)this.m_regs.get(i);
                boolean matched = false;
                if (className == null && (filter == null || filter.match(reg.getProperties()))) {
                    matched = true;
                } else if (className != null) {
                    Dictionary props = reg.getProperties();
                    String[] objectClass = (String[])props.get("objectClass");
                    for (int classIdx = 0; classIdx < objectClass.length; ++classIdx) {
                        if (!objectClass[classIdx].equals(className) || filter != null && !filter.match(props)) continue;
                        matched = true;
                        break;
                    }
                }
                if (!matched) continue;
                refs.add(reg.getReference());
            }
            if (!refs.isEmpty()) {
                return refs.toArray(new ServiceReference[refs.size()]);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference getServiceReference(String clazz) {
        List list = this.m_regs;
        synchronized (list) {
            try {
                ServiceReference[] refs = this.getServiceReferences(clazz, null);
                if (refs != null) {
                    return refs[0];
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ComponentInstance instance, ServiceReference ref) {
        List list = this.m_regs;
        synchronized (list) {
            ServiceRegistrationImpl reg = ((ServiceReferenceImpl)ref).getServiceRegistration();
            if (reg.isValid()) {
                return reg.getService();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        List list = this.m_regs;
        synchronized (list) {
            return this.getServiceReferences(clazz, filter);
        }
    }

    public void addServiceListener(ServiceListener listener, String filter) {
        if (filter == null) {
            this.addServiceListener(listener);
            return;
        }
        try {
            ListenerInfo info = new ListenerInfo();
            info.m_listener = listener;
            info.m_filter = this.m_context.createFilter(filter);
            this.m_listeners.add(info);
        }
        catch (InvalidSyntaxException ex) {
            this.m_logger.log(1, ex.getMessage(), ex);
        }
    }

    public void servicePropertiesModified(ServiceRegistrationImpl reg) {
        this.fireServiceChanged(new ServiceEvent(2, reg.getReference()));
    }

    public void unregisterService(ServiceRegistrationImpl reg) {
        this.m_regs.remove(reg);
        this.fireServiceChanged(new ServiceEvent(4, reg.getReference()));
    }

    public void reset() {
        this.m_serviceId = 1L;
        this.m_listeners = new ArrayList();
        this.m_regs = new ArrayList();
    }

    private static class ListenerInfo {
        private ServiceListener m_listener;
        private Filter m_filter;

        private ListenerInfo() {
        }
    }
}

