/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.configuration;

import java.util.List;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.Property;

public class ConfigurationHandlerDescription
extends HandlerDescription {
    private PropertyDescription[] m_properties;

    public ConfigurationHandlerDescription(Handler handler, List props) {
        super(handler);
        this.m_properties = new PropertyDescription[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            this.m_properties[i] = new PropertyDescription((Property)props.get(i));
        }
    }

    public Element getHandlerInfo() {
        Element elem = super.getHandlerInfo();
        for (int i = 0; i < this.m_properties.length; ++i) {
            String name = this.m_properties[i].getName();
            String value = this.m_properties[i].getValue();
            Element property = new Element("property", "");
            elem.addElement(property);
            if (name != null) {
                property.addAttribute(new Attribute("name", name));
            }
            if (value == null) continue;
            if (value == Property.NO_VALUE) {
                property.addAttribute(new Attribute("value", "NO_VALUE"));
                continue;
            }
            property.addAttribute(new Attribute("value", value.toString()));
        }
        return elem;
    }

    public PropertyDescription[] getProperties() {
        return this.m_properties;
    }
}

